/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.operands.ImmediateAddress;
import emulator.support.IndirectAddressOperandEval;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class IndirectAddress
extends ImmediateAddress {
    private int pointer;

    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException, BusWatchException {
        this.pointer = cpu.fetchProgramWord();
        this.addr = (this.pointer & 0xFF) == 255 ? new HwWord((long)(cpu.readByte(this.pointer) + (cpu.readByte(this.pointer - 255) << 8))) : new HwWord((long)cpu.readWord(this.pointer));
    }

    @Override
    public String getString() {
        return "($" + new HwWord((long)this.pointer) + ")   ; $" + this.addr;
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return "(" + symbols.getLabelOrAddress(mem_ref.getWordOp()) + ")";
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new IndirectAddressOperandEval(mem_ref);
    }
}

