/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.operands.ByteOperand;
import emulator.support.OperandEval;
import emulator.support.ZeroPageOperandEval;
import emulator.util.MemoryPtr;

public class ZeroPage
extends ByteOperand {
    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException, BusWatchException {
        super.init(cpu);
        this.setAddress(new HwWord((long)cpu.fetchProgramByte()));
    }

    @Override
    public String getString() {
        HwByte value = new HwByte(this.getAddress().getNumber());
        return "$" + value;
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return symbols.getLabelOrAddress(mem_ref.getByteOp());
    }

    @Override
    public int getExtraCycles() {
        return 1;
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new ZeroPageOperandEval(mem_ref);
    }
}

