/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.video;

import emulator.hardware.bus.VideoBus;
import java.util.Observable;

public class Vic6561ParameterCache
extends Observable {
    private int background_colour;
    private int char_height;
    private int columns;
    private int video_ram_address;
    private int char_rom_address;
    private int frame_colour;
    private int colour_ram_address;
    private int rows;
    private int fourth_colour;
    private int line_start;
    private int first_line;
    private boolean colour_mode;

    public int getBackgroundColour() {
        return this.background_colour;
    }

    private void setBackgroundColour(int background_colour) {
        this.background_colour = background_colour;
    }

    public int getCharHeight() {
        return this.char_height;
    }

    private void setCharHeight(int char_height) {
        this.char_height = char_height;
    }

    public int getColumns() {
        return this.columns;
    }

    private void setColumns(int columns) {
        this.columns = columns;
    }

    public int getVideoRamAddress() {
        return this.video_ram_address;
    }

    private void setVideoRamAddress(int video_ram_address) {
        this.video_ram_address = video_ram_address;
    }

    public int getCharRomAddress() {
        return this.char_rom_address;
    }

    private void setCharRomAddress(int char_rom_address) {
        this.char_rom_address = char_rom_address;
    }

    public int getFrameColour() {
        return this.frame_colour;
    }

    private void setFrameColour(int frame_colour) {
        this.frame_colour = frame_colour;
    }

    public int getColourRamAddress() {
        return this.colour_ram_address;
    }

    private void setColourRamAddress(int colour_ram_address) {
        this.colour_ram_address = colour_ram_address;
    }

    public int getRows() {
        return this.rows;
    }

    private void setRows(int rows) {
        this.rows = rows;
    }

    public int getFourthColour() {
        return this.fourth_colour;
    }

    private void setFourthColour(int fourth_colour) {
        this.fourth_colour = fourth_colour;
    }

    public int getLineStart() {
        return this.line_start;
    }

    private void setLineStart(int line_start) {
        this.line_start = line_start;
    }

    public int getFirstLine() {
        return this.first_line;
    }

    private void setFirstLine(int first_line) {
        this.first_line = first_line;
    }

    public boolean getColourMode() {
        return this.colour_mode;
    }

    private void setColourMode(boolean colour_mode) {
        this.colour_mode = colour_mode;
    }

    void update(int[] vic_registers) {
        this.setLineStart(Math.min((vic_registers[0] & 0x7F) * 4 - 32, 208));
        this.setFirstLine(vic_registers[1] * 2 - 40);
        this.setColumns(Math.min(32, vic_registers[2] & 0x7F));
        this.setColourRamAddress(5120 + 4 * (vic_registers[2] & 0x80));
        this.setColourRamAddress(VideoBus.convertAddress(this.getColourRamAddress()));
        this.setCharHeight((vic_registers[3] & 1) * 8 + 8);
        this.setRows(Math.min(38, vic_registers[3] >> 1 & 0x3F));
        this.setVideoRamAddress((vic_registers[2] & 0x80) << 2 | (vic_registers[5] & 0xF0) << 6);
        this.setVideoRamAddress(VideoBus.convertAddress(this.getVideoRamAddress()));
        this.setCharRomAddress((vic_registers[5] & 0xF) << 10);
        this.setCharRomAddress(VideoBus.convertAddress(this.getCharRomAddress()));
        this.setFourthColour(vic_registers[14] >> 4 & 0xF);
        this.setFrameColour(vic_registers[15] & 7);
        this.setColourMode((vic_registers[15] & 8) != 0);
        this.setBackgroundColour(vic_registers[15] >> 4 & 0xF);
        this.setChanged();
        this.notifyObservers();
    }
}

