/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell;

import emulator.GUI.FrameRegistry;
import emulator.assembler.Assembler;
import emulator.hardware.CPU;
import emulator.hardware.CPUEventHandler;
import emulator.hardware.bus.Bus;
import emulator.hardware.memory.MemoryBlockInterface;
import emulator.shell.ShellCommand;
import emulator.shell.commands.Break;
import emulator.shell.commands.Go;
import emulator.shell.commands.Halt;
import emulator.shell.commands.Irq;
import emulator.shell.commands.Load;
import emulator.shell.commands.Nmi;
import emulator.shell.commands.Quit;
import emulator.shell.commands.Reset;
import emulator.shell.commands.Set;
import emulator.shell.commands.Show;
import emulator.shell.commands.Step;
import emulator.shell.commands.Sys;
import emulator.shell.commands.Wait;
import emulator.shell.commands.Watch;
import emulator.util.AddressRange;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DebugShell
extends Thread
implements CPUEventHandler {
    private HashMap<String, ShellCommand> commands = new HashMap();
    private CPU cpu;
    private Bus bus;
    private Bus memory;
    private MemoryBlockInterface memory_block;
    private InputStream in = null;
    private PrintStream err;
    private PrintStream out;
    private Assembler assembler = new Assembler();
    private static DebugShell instance = null;
    private String start_script = null;

    public CPU getCpu() {
        return this.cpu;
    }

    public Bus getBus() {
        return this.bus;
    }

    public Bus getMemory() {
        return this.memory;
    }

    public void setStartScript(String start_script) {
        this.start_script = start_script;
    }

    public DebugShell(InputStream in, PrintStream out, PrintStream err) {
        this.in = in;
        this.out = out;
        this.err = err;
        this.initCommands();
        instance = this;
    }

    private void initCommands() {
        this.commands.put("go", new Go());
        this.commands.put("halt", new Halt());
        this.commands.put("quit", new Quit());
        this.commands.put("step", new Step());
        this.commands.put("irq", new Irq());
        this.commands.put("nmi", new Nmi());
        this.commands.put("reset", new Reset());
        this.commands.put("show", new Show());
        this.commands.put("watch", new Watch());
        this.commands.put("break", new Break());
        this.commands.put("set", new Set());
        this.commands.put("load", new Load());
        this.commands.put("sys", new Sys());
        this.commands.put("wait", new Wait());
    }

    public void init(CPU cpu, Bus bus) {
        this.cpu = cpu;
        this.bus = bus;
    }

    public void setMemory(Bus memory) {
        this.memory = memory;
    }

    public void setMemoryBlock(MemoryBlockInterface memory_block) {
        this.memory_block = memory_block;
    }

    @Override
    public void run() {
        this.startUp();
        this.executeStream(this.in);
        FrameRegistry.getInstance().saveFrameStates();
        System.exit(0);
    }

    private void executeStream(InputStream instream) {
        InputStreamReader inputStreamReader = new InputStreamReader(instream);
        BufferedReader stdin = new BufferedReader(inputStreamReader);
        boolean hasRequestedQuit = false;
        try {
            try {
                while (!hasRequestedQuit) {
                    String line = stdin.readLine();
                    if (line == null) {
                        break;
                    }
                    hasRequestedQuit = this.parseInput(line);
                }
            }
            catch (Exception ex) {
                this.err.println(ex);
                try {
                    instream.close();
                }
                catch (IOException e) {
                    this.err.println(e);
                }
            }
        }
        finally {
            try {
                instream.close();
            }
            catch (IOException e) {
                this.err.println(e);
            }
        }
    }

    private boolean parseInput(String line) throws Exception {
        String[] arg = this.splitCommandLine(line);
        if (arg.length > 0) {
            if (arg[0].toLowerCase().equals("help")) {
                ShellCommand command = null;
                if (arg.length > 1) {
                    command = this.commands.get(arg[1].toLowerCase());
                }
                if (command != null) {
                    command.printHelp(this);
                } else {
                    this.printHelp();
                }
            } else {
                ShellCommand command = this.commands.get(arg[0].toLowerCase());
                if (command != null) {
                    return command.execute(this, arg);
                }
                this.out.println("Unknown command \"" + arg[0] + "\"");
            }
        }
        return false;
    }

    private void printHelp() {
        this.out.println("Available commands:");
        String help_line = "";
        int cmd_idx = 0;
        for (Map.Entry<String, ShellCommand> entry : this.commands.entrySet()) {
            String outstr = String.valueOf(entry.getKey()) + "                   ";
            help_line = String.valueOf(help_line) + outstr.substring(0, 10);
            if (++cmd_idx % 4 != 0) continue;
            this.out.println(help_line);
            help_line = "";
        }
        if (!help_line.isEmpty()) {
            this.out.println(help_line);
        }
        this.out.println("\nTo get help for a specific command use:");
        this.out.println("help <command>");
    }

    private String[] splitCommandLine(String line) {
        ArrayList<String> string_array = new ArrayList<String>();
        while (!line.isEmpty()) {
            int start_index = 0;
            while (start_index < line.length() && Character.isWhitespace(line.charAt(start_index))) {
                ++start_index;
            }
            int end_index = start_index;
            while (end_index < line.length() && !Character.isWhitespace(line.charAt(end_index))) {
                ++end_index;
            }
            if (start_index >= end_index) continue;
            String part = line.substring(start_index, end_index);
            string_array.add(part);
            line = line.substring(end_index);
        }
        Object[] array = string_array.toArray();
        String[] arg = new String[array.length];
        int i = 0;
        while (i < array.length) {
            arg[i] = (String)array[i];
            ++i;
        }
        return arg;
    }

    private void startUp() {
        try {
            this.cpu.setEventHandler(this);
            this.cpu.reset();
            if (this.start_script != null) {
                this.out.println("Running " + this.start_script + "...");
                this.executeStream(new FileInputStream(this.start_script));
                this.out.println("Done.");
            }
            this.cpu.printState(this.out);
        }
        catch (Exception e) {
            this.err.println("DebugShell.startUp(): " + e);
        }
    }

    @Override
    public void notify(CPU cpu, String message) {
        this.out.println("CPU: " + message);
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public static DebugShell getInstance() {
        return instance;
    }

    public void execute(String command) {
        try {
            this.out.println("> " + command);
            this.parseInput(command);
        }
        catch (Exception ex) {
            this.err.println(ex);
        }
    }

    public MemoryBlockInterface getMemoryBlock() {
        return this.memory_block;
    }

    public Assembler getAssembler() {
        return this.assembler;
    }

    public void setAssembler(Assembler assembler) {
        this.assembler = assembler;
    }

    public int parseAddress(String label) {
        int address = this.getAssembler().getSymbols().findLabel(label);
        if (address < 0) {
            AddressRange range = AddressRange.fromString(label);
            address = range.getStart();
        }
        return address;
    }
}

