/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI;

import emulator.assembler.Assembler;
import emulator.hardware.CPU;
import emulator.hardware.bus.Bus;
import emulator.hardware.clock.Clock;
import emulator.hardware.io.Via6522;
import emulator.hardware.io.peripherals.iec.IecSim;
import emulator.hardware.memory.MemoryBlockInterface;
import emulator.shell.GUI.ConsoleFrame;
import emulator.shell.GUI.ConsoleInputFeedback;
import emulator.shell.GUI.ConsoleInputStream;
import emulator.shell.GUI.ConsoleOutputStream;
import emulator.util.events.EventAggregator;
import java.awt.Color;
import java.io.InputStream;
import java.io.PrintStream;

public class ShellUI {
    EventAggregator eventAggregator = new EventAggregator();
    private ConsoleFrame console;

    public ShellUI(String appName, CPU cpu, MemoryBlockInterface memory, Bus bus, Clock clock) {
        this.console = ConsoleFrame.createConsole(appName, cpu, memory, bus);
        ConsoleOutputStream outf = new ConsoleOutputStream(this.console, Color.black, true);
        ConsoleInputFeedback feedback = new ConsoleInputFeedback(outf);
        this.console.addObserver(feedback);
        this.console.setClock(clock);
    }

    public InputStream createIn() {
        ConsoleInputStream in = new ConsoleInputStream();
        this.console.addObserver(in);
        return in;
    }

    public PrintStream createOut() {
        ConsoleOutputStream out = new ConsoleOutputStream(this.console, Color.gray, false);
        return new PrintStream(out);
    }

    public PrintStream createErr() {
        ConsoleOutputStream err = new ConsoleOutputStream(this.console, Color.red, true);
        return new PrintStream(err);
    }

    public Assembler getAssembler() {
        return this.console.getAssembler();
    }

    public void setAssembler(Assembler assembler) {
        this.console.setAssembler(assembler);
    }

    public void setIecSim(IecSim iec_sim) {
        this.console.setIecSim(iec_sim);
    }

    public void setVias(Via6522 via1, Via6522 via2) {
        this.console.setVias(via1, via2);
    }

    public void initPortStateHistory() {
        this.console.initPortStateHistory(this.eventAggregator);
    }
}

