/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.debugger;

import emulator.assembler.AddressDictionary;
import emulator.assembler.Assembler;
import emulator.assembler.DataDescription;
import emulator.assembler.DataDescriptionTable;
import emulator.assembler.Instruction;

public class CodeInfo
implements AddressDictionary {
    public static final int ADDRESS_SPACE = 65536;
    private DataDescriptionTable description_table = null;
    private Assembler assembler = null;
    private byte[] memory;

    public CodeInfo(byte[] memory, Assembler assembler) {
        this.memory = memory;
        this.assembler = assembler;
        this.description_table = new DataDescriptionTable(0, memory.length - 1, 8);
    }

    public CodeInfo(byte[] memory, Assembler assembler, int mem_size) {
        if (mem_size > memory.length) {
            mem_size = memory.length;
        }
        this.memory = memory;
        this.assembler = assembler;
        this.description_table = new DataDescriptionTable(0, mem_size - 1, 8);
    }

    public DataDescriptionTable getDescriptionTable() {
        return this.description_table;
    }

    public void setDescriptionTable(DataDescriptionTable description_table) {
        this.description_table = description_table;
    }

    public Assembler getAssembler() {
        return this.assembler;
    }

    public byte[] getMemory() {
        return this.memory;
    }

    public int size() {
        return this.description_table.size();
    }

    public String getJumpLabel(int address) {
        return this.assembler.getSymbols().getJumpLabel(address);
    }

    @Override
    public String getLabel(int address) {
        return this.assembler.getSymbols().getLabelOrAddress(address);
    }

    public String getRemark(int address) {
        return this.assembler.getSymbols().getRemark(address);
    }

    public DataDescription getDescriptionForAddress(int address) {
        return this.description_table.getDescriptionForAddress(address);
    }

    public DataDescription getDescriptionForIndex(int index) {
        return this.description_table.getDescriptionForIndex(index);
    }

    public int getIndexForAddress(int address) {
        return this.description_table.getIndexForAddress(address);
    }

    public void analyzeOneInstruction(int address) {
        Instruction instruction = this.assembler.getInstruction(this.memory, address);
        this.description_table.insertInstruction(address, instruction);
        this.description_table.reindex();
    }

    public int getAddressForIndex(int line) {
        return this.description_table.getDescriptionForIndex(line).getAddress();
    }

    public int findLabel(String search_text) {
        return this.assembler.getSymbols().findLabel(search_text);
    }
}

