/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.debugger;

import emulator.assembler.CodeAnalyzer;
import emulator.assembler.DataDescriptionTable;
import emulator.shell.GUI.debugger.AnalyzerThread;
import emulator.shell.GUI.debugger.CodeInfo;
import java.util.LinkedList;
import java.util.Observer;

public class CodePanelAnalyzer {
    private DataDescriptionTable description_table = null;
    private boolean symbols_analyzed = false;
    private AnalyzerThread thread = null;

    public void startAnalysis(int address, CodeInfo info, Observer observer) {
        LinkedList<Integer> addresses = new LinkedList<Integer>();
        if (!this.isSymbolsAnalyzed()) {
            addresses = info.getAssembler().getSymbols().getCodeLabels();
            this.setSymbolsAnalyzed(true);
        }
        addresses.push(address);
        this.thread = new AnalyzerThread();
        this.description_table = new DataDescriptionTable(info.getDescriptionTable());
        this.thread.setAnalyzer(new CodeAnalyzer(info.getAssembler(), this.description_table, info.getMemory(), addresses));
        this.thread.addObserver(observer);
        this.thread.start();
    }

    public DataDescriptionTable getDescriptionTable() {
        return this.description_table;
    }

    public void setDescriptionTable(DataDescriptionTable description_table) {
        this.description_table = description_table;
    }

    public boolean isSymbolsAnalyzed() {
        return this.symbols_analyzed;
    }

    public void setSymbolsAnalyzed(boolean symbols_analyzed) {
        this.symbols_analyzed = symbols_analyzed;
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    public void ackStop() {
        this.thread = null;
    }
}

