/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.graph;

import emulator.history.BitStateChange;
import emulator.history.BitStateHistory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class BitGraphLine {
    private String label;
    private BitStateHistory stateHistory;
    private Color color = Color.black;
    private Stroke knownValueStroke = new BasicStroke(3.0f);
    private Stroke unknownValueStroke = new BasicStroke(3.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
    private int positionIndex = 0;

    public String getLabel() {
        return this.label;
    }

    public BitGraphLine setLabel(String label) {
        this.label = label;
        return this;
    }

    public BitStateHistory getStateHistory() {
        return this.stateHistory;
    }

    public BitGraphLine setStateHistory(BitStateHistory stateHistory) {
        this.stateHistory = stateHistory;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public BitGraphLine setColor(Color color) {
        this.color = color;
        return this;
    }

    public int getPositionIndex() {
        return this.positionIndex;
    }

    public BitGraphLine setPositionIndex(int positionIndex) {
        this.positionIndex = positionIndex;
        return this;
    }

    public Stroke getStroke() {
        return this.knownValueStroke;
    }

    public BitGraphLine setStroke(Stroke stroke) {
        this.knownValueStroke = stroke;
        return this;
    }

    public void draw(Graphics2D g2, long tickBegin, long tickEnd, int borderGapLeft, int borderGapTop, int lineGap, int width, double lineHeight) {
        if (this.stateHistory != null) {
            int yBase = (int)((double)borderGapTop + (double)this.positionIndex * (lineHeight + (double)lineGap));
            Stroke oldStroke = g2.getStroke();
            g2.setColor(this.color);
            BitStateChange previousState = this.stateHistory.getLessOrEqualElement(tickBegin);
            g2.setStroke(previousState != null ? this.knownValueStroke : this.unknownValueStroke);
            BitStateChange[] states = this.stateHistory.getRange(tickBegin, tickEnd - 1L);
            if (states.length == 0) {
                if (previousState != null) {
                    int y = previousState.getValue() ? yBase : (int)((double)yBase + lineHeight);
                    g2.drawLine(borderGapLeft, y, borderGapLeft + width, y);
                } else {
                    BitStateChange nextState = this.stateHistory.getGreaterOrEqualElement(tickEnd);
                    if (nextState != null) {
                        int y = nextState.getValue() ? (int)((double)yBase + lineHeight) : yBase;
                        g2.drawLine(borderGapLeft, y, borderGapLeft + width, y);
                    }
                }
            } else {
                double lastX = borderGapLeft;
                double scaleX = (double)width / (double)(tickEnd - tickBegin);
                int i = 0;
                while (i < states.length) {
                    double x = (double)borderGapLeft + scaleX * (double)(states[i].getTick() - tickBegin);
                    int y = states[i].getValue() ? (int)((double)yBase + lineHeight) : yBase;
                    g2.drawLine((int)lastX, y, (int)x, y);
                    g2.setStroke(this.knownValueStroke);
                    g2.drawLine((int)x, yBase, (int)x, (int)((double)yBase + lineHeight));
                    lastX = x;
                    ++i;
                }
                int y = states[states.length - 1].getValue() ? yBase : (int)((double)yBase + lineHeight);
                g2.drawLine((int)lastX, y, borderGapLeft + width, y);
            }
            g2.setStroke(oldStroke);
        }
    }
}

