/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.menu;

import emulator.assembler.Assembler;
import emulator.hardware.memory.MemoryBlockInterface;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.shell.GUI.debugger.DebugPanel;
import emulator.shell.GUI.windows.ManagedWindow;
import emulator.shell.GUI.windows.WindowManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WindowDebug
implements ActionListener {
    private int window_id;
    private WindowManager window_manager;
    private MemoryBlockInterface memory;
    private Assembler assembler;
    private Cpu6502 cpu;
    private DebugPanel debug_panel;

    public WindowDebug(WindowManager window_manager, int window_id, Assembler assembler, Cpu6502 cpu, MemoryBlockInterface memory) {
        this.window_manager = window_manager;
        this.window_id = window_id;
        this.assembler = assembler;
        this.cpu = cpu;
        this.memory = memory;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.window_manager.isWindowActive(this.window_id)) {
            this.closeWindow();
        } else {
            this.openWindow();
        }
    }

    private void openWindow() {
        ManagedWindow window = this.window_manager.createWindow(this.window_id, "Debug");
        this.debug_panel = new DebugPanel(window, this.assembler, this.cpu, this.memory.getData());
        window.getContentPane().add(this.debug_panel);
        window.restorePosition();
        window.setVisible(true);
    }

    private void closeWindow() {
        this.debug_panel.shutdown();
        this.window_manager.closeWindow(this.window_id);
    }
}

