/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.menu;

import com.jhe.hexed.JHexEditor;
import emulator.GUI.util.Clipboard;
import emulator.assembler.Assembler;
import emulator.hardware.memory.MemoryBlockInterface;
import emulator.shell.GUI.ToolBarWindow;
import emulator.shell.GUI.debugger.CodeInfo;
import emulator.shell.GUI.menu.MemoryQuery;
import emulator.shell.GUI.windows.ManagedWindow;
import emulator.shell.GUI.windows.WindowManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WindowMemory
extends ToolBarWindow
implements ActionListener {
    private int window_id;
    private WindowManager window_manager;
    private MemoryBlockInterface memory;
    private JTextField textfield_search;
    private JButton button_search;
    private JHexEditor hex_editor;
    private CodeInfo code_info;
    private ResetSearch _searchResultResetter = new ResetSearch();
    private Search _searchHandler = new Search();

    public WindowMemory(WindowManager window_manager, int window_id, Assembler assembler, MemoryBlockInterface memory) {
        this.window_manager = window_manager;
        this.window_id = window_id;
        this.memory = memory;
        this.code_info = new CodeInfo(memory.getData(), assembler, 65536);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.window_manager.isWindowActive(this.window_id)) {
            this.closeWindow();
        } else {
            this.openWindow();
        }
    }

    private void openWindow() {
        this.hex_editor = new JHexEditor(this.memory.getData(), new Clipboard());
        ManagedWindow window = this.window_manager.createWindow(this.window_id, "Memory");
        window.getContentPane().setLayout(new BorderLayout());
        window.getContentPane().add((Component)this.createToolBar(), "First");
        window.getContentPane().add((Component)this.hex_editor, "Center");
        window.restorePosition();
        window.setVisible(true);
    }

    private JToolBar createToolBar() {
        this.textfield_search = new JTextField();
        this.textfield_search.addActionListener(this._searchHandler);
        this.textfield_search.getDocument().addDocumentListener(this._searchResultResetter);
        this.button_search = WindowMemory.makeNavigationButton("images/search_icon.png", "Search for address or values", "search", new Search());
        this.textfield_search.setToolTipText("<html><b>Enter search text here.</b><br><br>Search for a <i>memory location</i> by <i>address</i> or <i>label</i> (e.g. '$3FC0' or 'init')<br>Search for <i>memory contents</i> by using the equal sign (=) followed by<ul><li>a series of byte values (e.g. '=$34 $56')</li><li>an ASCII string (e.g. '=\"load\"')</li></ul></html>");
        JToolBar toolbar = new JToolBar();
        if (this.memory.getData().length > 65536) {
            this.hex_editor.data.setBufferView(0, 65536);
            String[] memConfigStrings = new String[]{"Base memory (64K)", "FE3 Bank 0", "FE3 Bank 1", "FE3 Bank 2", "FE3 Bank 3", "FE3 Bank 4", "FE3 Bank 5", "FE3 Bank 6", "FE3 Bank 7", "FE3 Bank 8", "FE3 Bank 9", "FE3 Bank A", "FE3 Bank B", "FE3 Bank C", "FE3 Bank D", "FE3 Bank E", "FE3 Bank F"};
            JComboBox<String> memConfigCombo = new JComboBox<String>(memConfigStrings);
            memConfigCombo.setSelectedIndex(0);
            memConfigCombo.addActionListener(new MemoryViewSelector());
            toolbar.add(memConfigCombo);
            toolbar.addSeparator();
        }
        toolbar.add(this.textfield_search);
        toolbar.add(this.button_search);
        return toolbar;
    }

    private void closeWindow() {
        this.window_manager.closeWindow(this.window_id);
    }

    private void signalFailedSearch() {
        this.textfield_search.setBackground(Color.ORANGE);
    }

    private void resetSearch() {
        this._searchResultResetter.resetVisualState();
        this._searchHandler.resetQuery();
    }

    public class MemoryViewSelector
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            int index = cb.getSelectedIndex();
            int newOffset = 0;
            int newSize = 65536;
            if (index > 0) {
                newOffset = (index + 1) * 32768;
                newSize = 32768;
            }
            ((WindowMemory)WindowMemory.this).hex_editor.data.setBufferView(newOffset, newSize);
            WindowMemory.this.hex_editor.goTo(0);
            WindowMemory.this.resetSearch();
        }
    }

    public class ResetSearch
    implements DocumentListener {
        private void resetVisualState() {
            Color bk_color = UIManager.getColor("TextField.background");
            WindowMemory.this.textfield_search.setBackground(bk_color);
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.resetVisualState();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.resetVisualState();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.resetVisualState();
        }
    }

    public class Search
    implements ActionListener {
        private MemoryQuery _query = null;
        private String _searchText = "";

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!WindowMemory.this.textfield_search.getText().isEmpty()) {
                if (!this._searchText.equals(WindowMemory.this.textfield_search.getText()) || this._query == null) {
                    this._searchText = WindowMemory.this.textfield_search.getText();
                    this._query = new MemoryQuery(((WindowMemory)WindowMemory.this).hex_editor.data, this._searchText, WindowMemory.this.code_info);
                }
                if (!this._query.execute()) {
                    WindowMemory.this.signalFailedSearch();
                } else {
                    WindowMemory.this.hex_editor.goTo(this._query.getPosition());
                }
            }
        }

        public void resetQuery() {
            this._query = null;
        }
    }
}

