/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.profiling;

import emulator.hardware.HwWord;
import emulator.shell.GUI.profiling.CodeTableData;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.table.AbstractTableModel;

public class CodeTableModel
extends AbstractTableModel {
    private static String[] columns = new String[]{"Ratio (%)", "Cycles", "Hit count", "Avg. Cycles", "Address", "Label"};
    private ArrayList<CodeTableData> data = new ArrayList();
    private long totalTicks;

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex).getSumTicks() * 100L / this.totalTicks;
            }
            case 1: {
                return this.data.get(rowIndex).getSumTicks();
            }
            case 2: {
                return this.data.get(rowIndex).getHitCount();
            }
            case 3: {
                return (double)this.data.get(rowIndex).getSumTicks() / (double)this.data.get(rowIndex).getHitCount();
            }
            case 4: {
                return "$" + new HwWord((long)this.data.get(rowIndex).getAddress());
            }
            case 5: {
                return this.data.get(rowIndex).getLabel();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    public void addData(CodeTableData codeTableData) {
        this.data.add(codeTableData);
    }

    public void setTotalTicks(long totalTicks) {
        this.totalTicks = totalTicks;
    }

    public int getAddressAtRow(int rowIndex) {
        return this.data.get(rowIndex).getAddress();
    }

    public void postProcess() {
        Collections.sort(this.data);
    }
}

