/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.symbols;

import emulator.assembler.SymbolTableEntry;
import emulator.hardware.HwWord;
import emulator.shell.GUI.util.DialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditSymbolDialog
extends DialogBase {
    private String remark;
    private String label;
    private int type;
    private JTextField fieldSymbol;
    private JTextField fieldRemark;
    private JComboBox fieldType;

    public EditSymbolDialog(JFrame owner, SymbolTableEntry symbol) {
        super(owner, "Edit symbol", true);
        this.buildContents(symbol);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void buildContents(SymbolTableEntry symbol) {
        JLabel labelAddress = new JLabel("Address");
        JLabel labelSymbol = new JLabel("Label");
        JLabel labelRemark = new JLabel("Remark");
        JLabel labelType = new JLabel("Type");
        JLabel fieldAddress = new JLabel("$" + new HwWord((long)symbol.getAddress()));
        this.fieldSymbol = new JTextField(symbol.getLabel());
        this.fieldRemark = new JTextField(symbol.getRemark());
        this.fieldType = new JComboBox<String>(new String[]{"", "Code", "Data", "Word", "Text", "Chip", "Empty"});
        this.fieldType.setSelectedIndex(symbol.getType());
        JPanel editPanel = new JPanel();
        GroupLayout layout = new GroupLayout(editPanel);
        editPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(labelAddress).addComponent(labelSymbol).addComponent(labelRemark).addComponent(labelType)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(fieldAddress).addComponent(this.fieldSymbol).addComponent(this.fieldRemark).addComponent(this.fieldType)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(labelAddress).addComponent(fieldAddress)).addGroup(layout.createParallelGroup().addComponent(labelSymbol).addComponent(this.fieldSymbol)).addGroup(layout.createParallelGroup().addComponent(labelRemark).addComponent(this.fieldRemark)).addGroup(layout.createParallelGroup().addComponent(labelType).addComponent(this.fieldType)));
        layout.linkSize(0, labelAddress, labelSymbol, labelRemark, labelType);
        this.getContentPane().setLayout(new BorderLayout());
        this.add((Component)editPanel, "Center");
        this.add((Component)this.createButtonPanel(), "Last");
    }

    @Override
    protected void closeDialog(boolean result) {
        if (result) {
            this.label = this.fieldSymbol.getText();
            this.remark = this.fieldRemark.getText();
            this.type = this.fieldType.getSelectedIndex();
        }
        super.closeDialog(result);
    }

    public String getRemark() {
        return this.remark;
    }

    public String getLabel() {
        return this.label;
    }

    public int getType() {
        return this.type;
    }
}

