/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.symbols;

import emulator.assembler.SymbolTableSource;
import emulator.shell.GUI.symbols.SymbolSourceModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SymbolSourceTableModel
extends AbstractTableModel {
    private static String[] columns = new String[]{"", "Source"};
    private List<SymbolSourceModel> data;

    public SymbolSourceTableModel(List<SymbolSourceModel> model) {
        this.data = model;
    }

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex).isSelected();
            }
            case 1: {
                return this.data.get(rowIndex).getSourceName();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            this.data.get(rowIndex).setSelected((Boolean)aValue);
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 1;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    public Collection<SymbolTableSource> getSelectedSources() {
        ArrayList<SymbolTableSource> selectedSources = new ArrayList<SymbolTableSource>();
        for (SymbolSourceModel sourceModel : this.data) {
            if (!sourceModel.isSelected()) continue;
            selectedSources.add(sourceModel.getSource());
        }
        return selectedSources;
    }
}

