/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.symbols;

import emulator.assembler.SymbolTable;
import emulator.assembler.SymbolTableEntry;
import emulator.assembler.SymbolTableSource;
import emulator.hardware.HwWord;
import emulator.shell.GUI.symbols.SymbolSourceModel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SymbolTableModel
extends AbstractTableModel {
    private static String[] columns = new String[]{"Address", "Label", "Remark", "Type", "Source"};
    private static String[] typeNames = new String[]{"", "Code", "Data", "Word", "Text", "Chip", "Empty"};
    List<SymbolTableEntry> symbols = new ArrayList<SymbolTableEntry>();

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public int getRowCount() {
        return this.symbols.size();
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "$" + new HwWord((long)this.symbols.get(rowIndex).getAddress());
            }
            case 1: {
                return this.symbols.get(rowIndex).getLabel();
            }
            case 2: {
                return this.symbols.get(rowIndex).getRemark();
            }
            case 3: {
                return typeNames[this.symbols.get(rowIndex).getType()];
            }
            case 4: {
                return this.symbols.get(rowIndex).getSource();
            }
        }
        return null;
    }

    public void add(SymbolTableEntry entry) {
        this.symbols.add(entry);
    }

    public int getAddressAtSymbolLine(int rowIndex) {
        return this.symbols.get(rowIndex).getAddress();
    }

    public List<SymbolSourceModel> getSources(boolean selectUser) {
        LinkedHashSet<SymbolTableSource> sources = new LinkedHashSet<SymbolTableSource>();
        for (SymbolTableEntry entry : this.symbols) {
            sources.add(entry.getSource());
        }
        ArrayList<SymbolSourceModel> result = new ArrayList<SymbolSourceModel>();
        for (SymbolTableSource source : sources) {
            SymbolSourceModel sourceModel = new SymbolSourceModel();
            sourceModel.setSelected(selectUser && source == SymbolTable.userSymbol);
            sourceModel.setSource(source);
            sourceModel.setSourceName(source.getSourceName());
            result.add(sourceModel);
        }
        return result;
    }
}

