/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.symbols;

import emulator.GUI.PersistentFrame;
import emulator.shell.GUI.ToolBarWindow;
import emulator.shell.GUI.symbols.DeleteSymbolsDialog;
import emulator.shell.GUI.symbols.SaveSymbolsDialog;
import emulator.shell.GUI.symbols.SymbolSourceTableModel;
import emulator.shell.GUI.symbols.SymbolTablePresenter;
import emulator.shell.GUI.symbols.SymbolTableVM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

public class SymbolTableView
extends PersistentFrame {
    private SymbolTablePresenter presenter;
    private SymbolTableVM viewModel;
    private JTable symbolTable;
    private JToolBar toolbar;

    public SymbolTableView(String appName, SymbolTablePresenter presenter) {
        super("Symbols", appName);
        this.presenter = presenter;
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        super.windowClosing(arg0);
        this.presenter.onCloseView();
    }

    public void initView(SymbolTableVM viewModel) {
        this.getContentPane().setLayout(new BorderLayout());
        this.viewModel = viewModel;
        this.symbolTable = new JTable();
        this.symbolTable.setAutoCreateRowSorter(true);
        this.symbolTable.setModel(viewModel.getSymbolTableModel());
        this.symbolTable.addMouseListener(new SymbolTableListener());
        this.toolbar = new JToolBar();
        this.toolbar.add(ToolBarWindow.makeNavigationButton("images/file_load.png", "Load symbols from file", "Load", new LoadSymbols()));
        this.toolbar.add(ToolBarWindow.makeNavigationButton("images/file_save.png", "Save symbols to file", "Save", new SaveSymbols()));
        this.toolbar.addSeparator();
        this.toolbar.add(ToolBarWindow.makeNavigationButton("images/delete_icon.png", "Delete symbols", "Delete", new DeleteSymbols()));
        this.add((Component)this.toolbar, "First");
        this.getContentPane().add((Component)new JScrollPane(this.symbolTable), "Center");
    }

    public void updateViewModel(SymbolTableVM viewModel) {
        this.viewModel = viewModel;
        this.symbolTable.setModel(viewModel.getSymbolTableModel());
    }

    public class DeleteSymbols
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SymbolSourceTableModel tableModel = new SymbolSourceTableModel(SymbolTableView.this.viewModel.getSources(true));
            DeleteSymbolsDialog dialog = new DeleteSymbolsDialog(SymbolTableView.this, tableModel);
            dialog.setVisible(true);
            if (dialog.getResult()) {
                SymbolTableView.this.presenter.deleteSymbols(tableModel.getSelectedSources());
            }
        }
    }

    public class LoadSymbols
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String selected_file;
            FileDialog dialog = new FileDialog((Frame)SymbolTableView.this, "Load Symbols from File", 0);
            dialog.setVisible(true);
            if (dialog.getDirectory() != null && dialog.getFile() != null && !(selected_file = String.valueOf(dialog.getDirectory()) + dialog.getFile()).isEmpty()) {
                SymbolTableView.this.presenter.loadSymbols(selected_file);
            }
        }
    }

    public class SaveSymbols
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SymbolSourceTableModel tableModel = new SymbolSourceTableModel(SymbolTableView.this.viewModel.getSources(true));
            SaveSymbolsDialog dialog = new SaveSymbolsDialog(SymbolTableView.this, tableModel);
            dialog.setVisible(true);
            if (dialog.getResult()) {
                SymbolTableView.this.presenter.saveSymbols(dialog.getFileName(), tableModel.getSelectedSources());
            }
        }
    }

    public class SymbolTableListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int rowIndex = SymbolTableView.this.symbolTable.rowAtPoint(e.getPoint());
                int modelRow = SymbolTableView.this.symbolTable.convertRowIndexToModel(rowIndex);
                SymbolTableView.this.presenter.showCode(SymbolTableView.this.viewModel.getAddressAtSymbolLine(modelRow));
            }
        }
    }
}

