/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.viewmodel;

import emulator.hardware.io.peripherals.iec.DeviceInfo;
import emulator.hardware.io.peripherals.iec.IecSimDeviceRegistry;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DeviceTableModel
extends AbstractTableModel {
    String[] column_names = new String[]{"En", "#", "Type", "File"};
    int[] column_widths = new int[]{20, 20, 70, 100};
    Vector<DeviceInfo> devices = new Vector();
    private static final long serialVersionUID = 4776849022812402994L;

    public DeviceTableModel() {
        int[] device_numbers = IecSimDeviceRegistry.instance().enumDevices();
        int i = 0;
        while (i < device_numbers.length) {
            DeviceInfo device = IecSimDeviceRegistry.instance().getDevice(device_numbers[i]);
            if (device != null) {
                this.devices.add(device);
            }
            ++i;
        }
    }

    @Override
    public int getColumnCount() {
        return this.column_names.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.column_names[column];
    }

    public int getColumnWidth(int col) {
        return this.column_widths[col];
    }

    @Override
    public int getRowCount() {
        return this.devices.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.getDeviceForRow(row).isEnabled();
            }
            case 1: {
                return this.getDeviceForRow(row).getAddress();
            }
            case 2: {
                return this.getDeviceForRow(row).getType();
            }
            case 3: {
                return this.getDeviceForRow(row).getFile();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 1;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 0: {
                this.getDeviceForRow(row).setEnabled((Boolean)value);
                break;
            }
            case 2: {
                this.getDeviceForRow(row).setType((String)value);
                break;
            }
            case 3: {
                this.getDeviceForRow(row).setFile((String)value);
            }
        }
    }

    public DeviceInfo getDeviceForRow(int row) {
        return this.devices.get(row);
    }

    public void addDevice(DeviceInfo device) {
        int pos = 0;
        while (pos < this.devices.size()) {
            if (this.devices.get(pos).getAddress() > device.getAddress()) break;
            ++pos;
        }
        this.devices.insertElementAt(device, pos);
        this.fireTableRowsInserted(pos, pos);
    }

    public void removeDevice(DeviceInfo device) {
        int i = 0;
        while (i < this.devices.size()) {
            if (this.devices.get(i).getAddress() == device.getAddress()) {
                this.devices.remove(i);
                this.fireTableRowsDeleted(i, i);
                break;
            }
            ++i;
        }
    }
}

