/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.commands;

import emulator.EmulatorException;
import emulator.hardware.bus.VicBus;
import emulator.shell.DebugShell;
import emulator.shell.ShellCommand;
import emulator.util.AddressRange;

public class Set
implements ShellCommand {
    @Override
    public boolean execute(DebugShell shell, String[] arg) throws EmulatorException {
        if (arg.length != 3) {
            shell.getOut().println("Illegal parameter count.");
            this.printHelp(shell);
        } else {
            int block_state = 0;
            if (arg[1].equalsIgnoreCase("ram")) {
                block_state = 2;
            } else if (arg[1].equalsIgnoreCase("rom")) {
                block_state = 1;
            } else if (arg[1].equalsIgnoreCase("empty")) {
                block_state = 0;
            } else {
                try {
                    int value = AddressRange.addressFromString(arg[2]);
                    shell.getCpu().setValue(arg[1], value);
                }
                catch (NumberFormatException e) {
                    shell.getOut().println(String.valueOf(arg[2]) + " is not a number, exception=" + e.getMessage());
                    this.printHelp(shell);
                }
                return false;
            }
            int block_no = Integer.parseInt(arg[2]);
            VicBus bus = (VicBus)shell.getBus();
            switch (block_no) {
                case 0: {
                    bus.setBlock3k(block_state);
                    break;
                }
                case 1: {
                    bus.setBlock0(block_state);
                    break;
                }
                case 2: {
                    bus.setBlock1(block_state);
                    break;
                }
                case 3: {
                    bus.setBlock2(block_state);
                    break;
                }
                case 4: {
                    bus.setBlock3(block_state);
                }
            }
        }
        return false;
    }

    @Override
    public void printHelp(DebugShell shell) {
        shell.getOut().println("command syntax:");
        shell.getOut().println("set <register> <value> - set <register> to <value>");
        shell.getOut().println("set ram <config> \t   - set ram at <config>");
        shell.getOut().println("set rom <config> \t   - set ram at <config>");
        shell.getOut().println("set empty <config> \t   - set ram at <config>");
        shell.getOut().println("<config> = 0 .. 3k at $0400");
        shell.getOut().println("<config> = 1 .. 8k at $2000");
        shell.getOut().println("<config> = 2 .. 8k at $4000");
        shell.getOut().println("<config> = 3 .. 8k at $6000");
        shell.getOut().println("<config> = 4 .. 8k at $A000");
    }
}

