/*
 * Decompiled with CFR 0.152.
 */
package emulator.small;

import emulator.hardware.bits.SharedBit;
import emulator.hardware.bus.Bus;
import emulator.hardware.clock.Clock;
import emulator.hardware.clock.ClockHandle;
import emulator.hardware.clock.TickScales;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.video.test.NullClock;
import emulator.small.ViaStub;
import java.util.Observer;

public class Board {
    MemoryBlock memory;
    TickScales clock_scales = new TickScales();
    ViaStub via1 = new ViaStub();
    ViaStub via2 = new ViaStub();

    public void setIrqLines(SharedBit nmi_out, SharedBit irq_out) {
        this.via1.setIrqOut(nmi_out);
        this.via2.setIrqOut(irq_out);
    }

    public MemoryBlock getMemory() {
        return this.memory;
    }

    public void setMemory(MemoryBlock memory) {
        this.memory = memory;
    }

    public void handleClock(long tick_cnt) {
        this.via1.handleClock(tick_cnt);
        this.via2.handleClock(tick_cnt);
    }

    public Bus getBus() {
        return new BoardBus();
    }

    public Clock getCpuClock() {
        return new CpuClock();
    }

    public Clock getVicClock() {
        return new NullClock();
    }

    public class BoardBus
    implements Bus {
        @Override
        public void write(int address, int data) throws BusWatchException, UnmappedMemoryException {
            if (address < 49152 && (address < 8192 || address >= 36864)) {
                if (address >= 36864 && address < 37888) {
                    if (address > 36879) {
                        if ((address & 0x10) != 0) {
                            Board.this.via1.writeRegister(address, data);
                        } else if ((address & 0x20) != 0) {
                            Board.this.via2.writeRegister(address, data);
                        }
                    }
                } else {
                    Board.this.memory.write(address, data);
                }
            }
        }

        @Override
        public int read(int address) throws BusWatchException, UnmappedMemoryException {
            if (address >= 36864 && address < 37888) {
                if (address > 36879) {
                    if ((address & 0x10) != 0) {
                        return Board.this.via1.readRegister(address);
                    }
                    if ((address & 0x20) != 0) {
                        return Board.this.via2.readRegister(address);
                    }
                }
            } else if (address < 1024 || address >= 4096 && address < 8192 || address >= 32768) {
                return Board.this.memory.read(address);
            }
            return address >> 8 & 0xFF;
        }
    }

    public class CpuClock
    implements Clock {
        @Override
        public ClockHandle acquireHandle() {
            return new CpuClockHandle();
        }

        @Override
        public void releaseHandle(ClockHandle handle) {
        }

        @Override
        public void addClockSpeedObserver(Observer clockSpeedObserver) {
            Board.this.clock_scales.addObserver(clockSpeedObserver);
        }
    }

    public class CpuClockHandle
    implements ClockHandle {
        long tick_cnt = 0L;

        CpuClockHandle() {
            Board.this.clock_scales.init();
        }

        @Override
        public void tick() {
            this.tick(1);
        }

        @Override
        public void tick(int x) {
            this.tick_cnt += (long)x;
            Board.this.clock_scales.measureTicks(this.tick_cnt);
            Board.this.handleClock(this.tick_cnt);
        }

        @Override
        public long getTicks() {
            return this.tick_cnt;
        }
    }
}

