/*
 * Decompiled with CFR 0.152.
 */
package emulator.small;

import emulator.hardware.bits.SharedBit;

public class ViaStub {
    static final int ORB = 0;
    static final int ORA = 1;
    static final int DDRB = 2;
    static final int DDRA = 3;
    static final int T1CL = 4;
    static final int T1CH = 5;
    static final int T1LL = 6;
    static final int T1LH = 7;
    static final int T2CL = 8;
    static final int T2CH = 9;
    static final int SR = 10;
    static final int ACR = 11;
    static final int PCR = 12;
    static final int IFR = 13;
    static final int IER = 14;
    static final int ORA2 = 15;
    private SharedBit irq_out;
    private Timer timer1 = new Timer(6);
    private Timer timer2 = new Timer(5);
    int[] registers = new int[16];

    void setIrqOut(SharedBit irq_out) {
        this.irq_out = irq_out;
        this.irq_out.setValue(true);
    }

    private void setInterrupt(int index) {
        this.registers[13] = this.registers[13] | 1 << index;
        this.checkInterrupts();
    }

    private void clearInterrupt(int index) {
        this.registers[13] = this.registers[13] & ~(1 << index);
        this.checkInterrupts();
    }

    private void checkInterrupts() {
        if ((this.registers[13] & this.registers[14] & 0x7F) != 0) {
            this.registers[13] = this.registers[13] | 0x80;
            this.irq_out.setValue(false);
        } else {
            this.registers[13] = this.registers[13] & 0x7F;
            this.irq_out.setValue(true);
        }
    }

    public void writeRegister(int reg, int data) {
        int byte_reg = reg & 0xF;
        int data_byte = data & 0xFF;
        switch (byte_reg) {
            case 4: {
                break;
            }
            case 5: {
                this.timer1.setTimerLatch(this.registers[4] + (data_byte << 8));
                this.timer1.startTimer();
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.timer1.setTimerLatch(this.registers[6] + (data_byte << 8));
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.timer2.setTimerLatch(this.registers[8] + (data_byte << 8));
                this.timer2.startTimer();
                break;
            }
            case 14: {
                data_byte = (data_byte & 0x80) != 0 ? data & 0x7F | this.registers[14] : this.registers[14] & ~data;
            }
        }
        this.registers[byte_reg] = data_byte;
    }

    public int readRegister(int reg) {
        int byte_reg = reg & 0xF;
        switch (byte_reg) {
            case 4: {
                this.clearInterrupt(6);
                break;
            }
            case 8: {
                this.clearInterrupt(5);
            }
        }
        return this.registers[byte_reg];
    }

    public void handleClock(long tick_cnt) {
        this.timer1.handleClock(tick_cnt);
        this.timer2.handleClock(tick_cnt);
    }

    public class Timer {
        private boolean is_running;
        private long trigger_ticks;
        private long timer_latch;
        private long last_clock;
        private int irq_index;

        Timer(int index) {
            this.stopTimer();
            this.irq_index = index;
        }

        public void handleClock(long tick_cnt) {
            if (this.is_running && tick_cnt >= this.trigger_ticks) {
                this.trigger_ticks += this.timer_latch;
                this.fire();
            }
            this.last_clock = tick_cnt;
        }

        private void fire() {
            ViaStub.this.setInterrupt(this.irq_index);
        }

        public void startTimer() {
            this.trigger_ticks = this.last_clock + this.timer_latch;
            this.is_running = true;
            ViaStub.this.clearInterrupt(this.irq_index);
        }

        public void stopTimer() {
            this.is_running = false;
        }

        public void setTimerLatch(long latch) {
            this.timer_latch = latch;
        }
    }
}

