/*
 * Decompiled with CFR 0.152.
 */
package emulator.support;

import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.support.CpuState;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class IndirectXOperandEval
implements OperandEval {
    MemoryPtr instruction;

    public IndirectXOperandEval(MemoryPtr ptr) {
        this.instruction = ptr;
    }

    @Override
    public String getDetails(CpuState cpu_state) {
        int old_address = this.instruction.getAddress();
        int address = this.instruction.getByteOp();
        int reg_x = cpu_state.getValue("X");
        int zp_adr = address + reg_x & 0xFF;
        this.instruction.setAddress(zp_adr);
        int ptr = this.instruction.getWordOp();
        this.instruction.setAddress(ptr);
        int value = this.instruction.getByteOp();
        String result = "(($" + new HwByte((long)address) + " + $" + new HwByte((long)reg_x) + " -> $" + new HwByte((long)zp_adr) + ") -> $" + new HwWord((long)ptr) + ") -> $" + new HwByte((long)value);
        this.instruction.setAddress(old_address);
        return result;
    }

    @Override
    public boolean isAddress() {
        return true;
    }

    @Override
    public int getAddress(CpuState cpu_state) {
        int old_address = this.instruction.getAddress();
        int address = this.instruction.getByteOp();
        int reg_x = cpu_state.getValue("X");
        int zp_adr = address + reg_x & 0xFF;
        this.instruction.setAddress(zp_adr);
        int ptr = this.instruction.getWordOp();
        this.instruction.setAddress(old_address);
        return ptr;
    }

    @Override
    public boolean isIndirect() {
        return true;
    }
}

