/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.assembler;

import emulator.assembler.DataDescription;
import emulator.assembler.DataDescriptionTable;
import emulator.assembler.Instruction;
import emulator.assembler.SymbolTable;
import emulator.hardware.nmos6502.commands.BIT;
import emulator.hardware.nmos6502.commands.BRK;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.NoOperand;
import emulator.util.MemoryPtr;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataDescriptionTableTest {
    private static final int max_range = 32;
    private static final int initial_gran = 8;
    private DataDescriptionTable table = null;

    @Before
    public void setUp() throws Exception {
        this.table = new DataDescriptionTable(0, 31, 8);
    }

    @After
    public void tearDown() throws Exception {
        this.table = null;
    }

    @Test
    public void testInitialize() {
        Assert.assertEquals((long)this.getInitialTableSize(), (long)this.table.size());
        int i = 0;
        while (i < this.getInitialTableSize()) {
            this.assertIsUntouched(i, i * 8);
            ++i;
        }
    }

    private void assertIsUntouched(int i, int address) {
        DataDescription data = this.table.getDescriptionForIndex(i);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)address, (long)data.getAddress());
        Assert.assertFalse((boolean)data.isCode());
        Assert.assertFalse((boolean)data.isJumpTarget());
        Assert.assertEquals((long)0L, (long)data.getAccessCount());
    }

    @Test
    public void testInsertBreakFront() {
        byte[] memory = new byte[1];
        MemoryPtr mem_ref = new MemoryPtr(memory, 0);
        Instruction instruction = new Instruction(mem_ref, new BRK(), new NoOperand(), null);
        this.table.insertInstruction(0, instruction);
        this.table.reindex();
        Assert.assertEquals((long)(this.getInitialTableSize() + 1), (long)this.table.size());
        this.checkData(this.table.getDescriptionForIndex(0), 0, 1, true, false);
        this.checkData(this.table.getDescriptionForIndex(1), 1, 7, false, false);
        int i = 1;
        while (i < this.getInitialTableSize()) {
            this.assertIsUntouched(i + 1, i * 8);
            ++i;
        }
    }

    private void checkData(DataDescription actual_data, int expected_address, int expected_length, boolean expected_iscode, boolean expected_isjumptarget) {
        Assert.assertNotNull((Object)actual_data);
        Assert.assertEquals((long)expected_address, (long)actual_data.getAddress());
        Assert.assertEquals((long)expected_length, (long)actual_data.getLength());
        Assert.assertEquals((Object)expected_iscode, (Object)actual_data.isCode());
        Assert.assertEquals((Object)expected_isjumptarget, (Object)actual_data.isJumpTarget());
    }

    @Test
    public void testShiftEntryBegin() {
        DataDescription data = this.table.getDescriptionForIndex(0);
        this.table.shiftEntryBegin(data, 1);
        this.checkData(data, 1, 7, false, false);
    }

    @Test
    public void testInsertCodeBlock() {
        this.table.shiftEntryBegin(this.table.getDescriptionForIndex(0), 1);
        this.table.insertCodeBlock(0, 1);
        this.checkData(this.table.getDescriptionForAddress(0), 0, 1, true, false);
    }

    @Test
    public void testInsertTwoInstructions() {
        byte[] memory = new byte[1];
        MemoryPtr mem_ref = new MemoryPtr(memory, 0);
        Instruction instruction = new Instruction(mem_ref, new BRK(), new NoOperand(), null);
        this.table.insertInstruction(0, instruction);
        this.table.insertInstruction(2, instruction);
        this.table.reindex();
        Assert.assertEquals((long)(this.getInitialTableSize() + 3), (long)this.table.size());
        this.checkData(this.table.getDescriptionForIndex(0), 0, 1, true, false);
        this.checkData(this.table.getDescriptionForIndex(1), 1, 1, false, false);
        this.checkData(this.table.getDescriptionForIndex(2), 2, 1, true, false);
        this.checkData(this.table.getDescriptionForIndex(3), 3, 5, false, false);
        int i = 1;
        while (i < this.getInitialTableSize()) {
            this.assertIsUntouched(i + 3, i * 8);
            ++i;
        }
    }

    @Test
    public void testInsertMergeInstructions() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        byte[] memory = byArray;
        MemoryPtr mem_ref = new MemoryPtr(memory, 0);
        Instruction instruction1 = new Instruction(mem_ref, new BRK(), new NoOperand(), null);
        Instruction instruction3 = new Instruction(mem_ref, new BIT(), new Absolute(), new SymbolTable());
        this.table.insertInstruction(0, instruction1);
        this.table.insertInstruction(2, instruction1);
        this.table.insertInstruction(0, instruction3);
        this.table.reindex();
        Assert.assertEquals((long)(this.getInitialTableSize() + 1), (long)this.table.size());
        this.checkData(this.table.getDescriptionForIndex(0), 0, 3, true, false);
        this.checkData(this.table.getDescriptionForIndex(1), 3, 5, false, false);
        int i = 1;
        while (i < this.getInitialTableSize()) {
            this.assertIsUntouched(i + 1, i * 8);
            ++i;
        }
    }

    private int getInitialTableSize() {
        return 4;
    }
}

