/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.debug;

import emulator.EmulatorException;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.debug.WatchWrites;
import emulator.hardware.memory.SparseMemory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WatchWritesTest {
    private SparseMemory memory;
    private WatchWrites watcher;

    @Before
    public void setUp() throws Exception {
        this.memory = new SparseMemory();
        this.watcher = new WatchWrites(this.memory, new HwWord(49152L), new HwWord(65535L));
    }

    @Test(expected=BusWatchException.class)
    public void testWriteWatch1() throws EmulatorException {
        this.watcher.write(49152, 0);
    }

    @Test(expected=BusWatchException.class)
    public void testWriteWatch2() throws EmulatorException {
        this.watcher.write(49153, 0);
    }

    @Test(expected=BusWatchException.class)
    public void testWriteWatch3() throws EmulatorException {
        this.watcher.write(65535, 0);
    }

    @Test
    public void testWriteThroughBorder() throws EmulatorException {
        this.watcher.write(49151, 247);
        Assert.assertEquals((long)247L, (long)this.memory.read(49151));
    }

    @Test
    public void testWriteThrough() throws EmulatorException {
        this.watcher.write(40960, 247);
        Assert.assertEquals((long)247L, (long)this.memory.read(40960));
    }
}

