/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.io;

import emulator.hardware.bits.SharedBit;
import emulator.hardware.io.Port6522;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Port6522Test {
    SharedBit[] in_port_bit = new SharedBit[8];
    SharedBit[] out_port_bit = new SharedBit[8];
    SharedBit[] control_bit = new SharedBit[2];
    Port6522 port = new Port6522();

    @Before
    public void setUp() throws Exception {
        int i = 0;
        while (i < 8) {
            this.in_port_bit[i] = this.port.getInPortBit(i);
            this.out_port_bit[i] = this.port.getOutPortBit(i);
            ++i;
        }
        i = 0;
        while (i < 2) {
            this.control_bit[i] = this.port.getControlBit(i);
            ++i;
        }
        this.resetBits();
    }

    private void resetBits() {
        SharedBit.setBits(this.in_port_bit, 0);
        SharedBit.setBits(this.out_port_bit, 0);
        SharedBit.setBits(this.control_bit, 0);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testInitPortBits() {
        int i = 0;
        while (i < 8) {
            Assert.assertNotNull((Object)this.in_port_bit[i]);
            Assert.assertNotNull((Object)this.out_port_bit[i]);
            ++i;
        }
    }

    @Test
    public void testInitControlBits() {
        int i = 0;
        while (i < 2) {
            Assert.assertNotNull((Object)this.control_bit[i]);
            ++i;
        }
    }

    @Test
    public void testSetGetMask() {
        this.port.setPortMask(15);
        Assert.assertEquals((long)15L, (long)this.port.getPortMask());
        this.port.setPortMask(240);
        Assert.assertEquals((long)240L, (long)this.port.getPortMask());
    }

    @Test
    public void testWritePort() {
        this.port.setPortMask(255);
        this.port.writePort(85);
        Assert.assertEquals((long)85L, (long)SharedBit.getBits(this.out_port_bit));
        this.port.writePort(170);
        Assert.assertEquals((long)170L, (long)SharedBit.getBits(this.out_port_bit));
    }

    @Test
    public void testWritePortMasked() {
        this.port.setPortMask(85);
        this.port.writePort(240);
        Assert.assertEquals((long)80L, (long)SharedBit.getBits(this.out_port_bit));
        this.resetBits();
        this.port.setPortMask(170);
        this.port.writePort(15);
        Assert.assertEquals((long)10L, (long)SharedBit.getBits(this.out_port_bit));
    }

    @Test
    public void testWritePortMaskedUntouched() {
        this.port.setPortMask(85);
        this.out_port_bit[1].setValue(true);
        this.port.writePort(240);
        Assert.assertEquals((long)82L, (long)SharedBit.getBits(this.out_port_bit));
        this.port.setPortMask(170);
        this.port.writePort(15);
        Assert.assertEquals((long)90L, (long)SharedBit.getBits(this.out_port_bit));
    }

    @Test
    public void testReadPort() {
        SharedBit.setBits(this.in_port_bit, 85);
        Assert.assertEquals((long)85L, (long)this.port.readPort());
        SharedBit.setBits(this.in_port_bit, 170);
        Assert.assertEquals((long)170L, (long)this.port.readPort());
    }
}

