/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.io.peripherals;

import emulator.hardware.io.Port6522;
import emulator.hardware.io.peripherals.KeyboardMatrix;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyboardMatrixTest {
    private KeyboardMatrix matrix;
    private Port6522 portA;
    private Port6522 portB;

    @Before
    public void setUp() throws Exception {
        this.matrix = new KeyboardMatrix();
        this.portA = new Port6522();
        this.portB = new Port6522();
        this.portB.setPortMask(255);
        this.matrix.attachToPort(this.portB, this.portA);
    }

    @Test
    public void testInit() {
        this.portB.writePort(255);
        Assert.assertEquals((long)255L, (long)this.portA.readPort());
    }

    @Test
    public void testClosedGates() {
        int i = 0;
        while (i < 8) {
            this.portB.writePort(~(1 << i));
            Assert.assertEquals((long)255L, (long)this.portA.readPort());
            ++i;
        }
    }

    @Test
    public void testReadOneGate() {
        this.matrix.keyDown(3, 2);
        this.portB.writePort(0);
        Assert.assertEquals((long)247L, (long)this.portA.readPort());
        int i = 0;
        while (i < 8) {
            this.portB.writePort(~(1 << i));
            Assert.assertEquals((long)(i == 2 ? 247 : 255), (long)this.portA.readPort());
            ++i;
        }
    }

    @Test
    public void testReadTwoGates() {
        this.matrix.keyDown(1, 2);
        this.matrix.keyDown(4, 3);
        this.portB.writePort(0);
        Assert.assertEquals((long)237L, (long)this.portA.readPort());
        int i = 0;
        while (i < 8) {
            this.portB.writePort(~(1 << i));
            if (i == 2) {
                Assert.assertEquals((long)253L, (long)this.portA.readPort());
            } else if (i == 3) {
                Assert.assertEquals((long)239L, (long)this.portA.readPort());
            } else {
                Assert.assertEquals((long)255L, (long)this.portA.readPort());
            }
            ++i;
        }
    }
}

