/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.memory;

import emulator.EmulatorException;
import emulator.hardware.memory.DebugMemoryBlock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DebugMemoryBlockReadonlyTest {
    private DebugMemoryBlock memory;

    @Before
    public void setUp() throws Exception {
        this.memory = new DebugMemoryBlock(4096);
        this.memory.enableReadonly(512, 767, true);
    }

    @Test
    public void testReadWriteBelow() throws EmulatorException {
        int address = 511;
        this.memory.write(address, 85);
        Assert.assertEquals((long)85L, (long)this.memory.read(address));
    }

    @Test
    public void testReadWriteStart() throws EmulatorException {
        int address = 512;
        this.memory.write(address, 85);
        Assert.assertEquals((long)0L, (long)this.memory.read(address));
    }

    @Test
    public void testReadWriteStop() throws EmulatorException {
        int address = 767;
        this.memory.write(address, 85);
        Assert.assertEquals((long)0L, (long)this.memory.read(address));
    }

    @Test
    public void testReadWriteAbove() throws EmulatorException {
        int address = 768;
        this.memory.write(address, 85);
        Assert.assertEquals((long)85L, (long)this.memory.read(address));
    }
}

