/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502;

import emulator.hardware.nmos6502.BreakPoints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BreakPointsTest {
    private BreakPoints breakpoints;
    private int break1 = 13;
    private int break2 = 21;
    private int stop1 = 7;
    private int stop2 = 15;

    @Before
    public void setUp() throws Exception {
        this.breakpoints = new BreakPoints();
        this.breakpoints.addBreak(this.break1);
        this.breakpoints.addBreak(this.break2);
        this.breakpoints.addStop(this.stop1);
        this.breakpoints.addStop(this.stop2);
    }

    @Test
    public void testBreaks() {
        Assert.assertFalse((boolean)this.breakpoints.checkBreak(0));
        Assert.assertTrue((boolean)this.breakpoints.checkBreak(this.break1));
        Assert.assertTrue((boolean)this.breakpoints.checkBreak(this.break2));
    }

    @Test
    public void testStops() {
        Assert.assertTrue((boolean)this.breakpoints.checkBreak(this.stop1));
        Assert.assertTrue((boolean)this.breakpoints.checkBreak(this.stop2));
    }

    @Test
    public void testClearStops() {
        this.breakpoints.clearAllStops();
        Assert.assertFalse((boolean)this.breakpoints.checkBreak(this.stop1));
        Assert.assertFalse((boolean)this.breakpoints.checkBreak(this.stop2));
        Assert.assertTrue((boolean)this.breakpoints.checkBreak(this.break1));
        Assert.assertTrue((boolean)this.breakpoints.checkBreak(this.break2));
    }

    @Test
    public void testRemoveBreak() {
        this.breakpoints.removeBreak(this.break2);
        Assert.assertTrue((boolean)this.breakpoints.checkBreak(this.break1));
        Assert.assertFalse((boolean)this.breakpoints.checkBreak(this.break2));
        Assert.assertTrue((boolean)this.breakpoints.checkBreak(this.stop1));
        Assert.assertTrue((boolean)this.breakpoints.checkBreak(this.stop2));
    }
}

