/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.OperandException;
import emulator.support.NullOperandEval;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class MockOperand
implements Operand {
    long operand = 0L;

    public MockOperand() {
    }

    public MockOperand(long operand) {
        this.operand = operand;
    }

    @Override
    public HwByte getByte() throws OperandException, UnmappedMemoryException {
        return new HwByte(this.operand);
    }

    @Override
    public HwWord getWord() throws OperandException {
        return new HwWord(this.operand);
    }

    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException {
    }

    @Override
    public void setByte(HwByte data) throws OperandException {
        this.operand = data.getNumber();
    }

    @Override
    public void setWord(HwWord data) throws OperandException {
        this.operand = data.getNumber();
    }

    public long getOperand() {
        return this.operand;
    }

    public void setOperand(long operand) {
        this.operand = operand;
    }

    @Override
    public String getString() {
        return "MockOperand(" + this.operand + ")";
    }

    @Override
    public int getByteCount() {
        return 0;
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return "MockOperand(" + this.operand + ")";
    }

    @Override
    public int getExtraCycles() {
        return 0;
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new NullOperandEval();
    }
}

