/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.clock.ClockImplementation;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.BRK;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Test;

public class BRKTest {
    @Test
    public void testExecute() throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        MemoryBlock memory = new MemoryBlock(65536);
        memory.write(65534, 210);
        memory.write(65535, 255);
        ClockImplementation clock = new ClockImplementation();
        cpu.attach(memory, clock);
        cpu.setPC(6699);
        cpu.setSP(new HwByte(255L));
        BRK brk = new BRK();
        brk.execute(cpu, new NoOperand());
        Assert.assertEquals((Object)new HwByte(252L), (Object)cpu.getSP());
        Assert.assertEquals((Object)new HwWord(65490L), (Object)cpu.getPC());
        Assert.assertEquals((long)26L, (long)memory.read(511));
        Assert.assertEquals((long)44L, (long)memory.read(510));
        Assert.assertEquals((Object)new Flags6502(16L), (Object)new HwByte((long)memory.read(509)));
    }
}

