/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwWord;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.unittest.hardware.nmos6502.MockOperand;
import org.junit.Assert;
import org.junit.Test;

public class BranchTestBase {
    protected Command branch_command;
    protected int bit;
    protected boolean value;

    @Test
    public void testBranchNot() throws EmulatorException {
        if (this.branch_command != null) {
            Cpu6502 cpu = new Cpu6502();
            cpu.setPC(0);
            Flags6502 flags = cpu.getFlags();
            flags.setBit(this.bit, !this.value);
            cpu.setFlags(flags);
            this.branch_command.execute(cpu, new MockOperand(63L));
            Assert.assertEquals((Object)new HwWord(0L), (Object)cpu.getPC());
        }
    }

    @Test
    public void testBranchForward() throws EmulatorException {
        if (this.branch_command != null) {
            Cpu6502 cpu = new Cpu6502();
            cpu.setPC(0);
            Flags6502 flags = cpu.getFlags();
            flags.setBit(this.bit, this.value);
            cpu.setFlags(flags);
            this.branch_command.execute(cpu, new MockOperand(63L));
            Assert.assertEquals((Object)new HwWord(63L), (Object)cpu.getPC());
        }
    }

    @Test
    public void testBranchBackwards() throws EmulatorException {
        if (this.branch_command != null) {
            Cpu6502 cpu = new Cpu6502();
            cpu.setPC(511);
            Flags6502 flags = cpu.getFlags();
            flags.setBit(this.bit, this.value);
            cpu.setFlags(flags);
            this.branch_command.execute(cpu, new MockOperand(254L));
            Assert.assertEquals((Object)new HwWord(509L), (Object)cpu.getPC());
        }
    }
}

