/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.unittest.hardware.nmos6502.MockOperand;
import org.junit.Assert;

public class CommandTestBase {
    protected Command command;

    protected void executeAndCheckCommandOnAccu(Command command, int flags_pre, int accu_pre, int op, int flags_post, int accu_post) throws EmulatorException {
        MockOperand operand = new MockOperand(op);
        Cpu6502 cpu = new Cpu6502();
        cpu.setFlags(new Flags6502((long)flags_pre));
        cpu.setAccu(new HwByte((long)accu_pre));
        command.execute(cpu, operand);
        Assert.assertEquals((long)accu_post, (long)cpu.getAccu().getNumber());
        Assert.assertEquals((Object)new Flags6502((long)flags_post), (Object)cpu.getFlags());
    }

    protected void executeAndCheckCommandOnX(Command command, int flags_pre, int value_pre, int op, int flags_post, int value_post) throws EmulatorException {
        MockOperand operand = new MockOperand(op);
        Cpu6502 cpu = new Cpu6502();
        cpu.setFlags(new Flags6502((long)flags_pre));
        cpu.setX(new HwByte((long)value_pre));
        command.execute(cpu, operand);
        Assert.assertEquals((long)value_post, (long)cpu.getX().getNumber());
        Assert.assertEquals((Object)new Flags6502((long)flags_post), (Object)cpu.getFlags());
    }

    protected void executeAndCheckCommandOnY(Command command, int flags_pre, int value_pre, int op, int flags_post, int value_post) throws EmulatorException {
        MockOperand operand = new MockOperand(op);
        Cpu6502 cpu = new Cpu6502();
        cpu.setFlags(new Flags6502((long)flags_pre));
        cpu.setY(new HwByte((long)value_pre));
        command.execute(cpu, operand);
        Assert.assertEquals((long)value_post, (long)cpu.getY().getNumber());
        Assert.assertEquals((Object)new Flags6502((long)flags_post), (Object)cpu.getFlags());
    }

    protected void executeAndCheckCommandOnOperand(Command command, int flags_pre, int op_pre, int flags_post, int op_post) throws EmulatorException {
        MockOperand operand = new MockOperand(op_pre);
        Cpu6502 cpu = new Cpu6502();
        cpu.setFlags(new Flags6502((long)flags_pre));
        command.execute(cpu, operand);
        Assert.assertEquals((long)op_post, (long)operand.getByte().getNumber());
        Assert.assertEquals((Object)new Flags6502((long)flags_post), (Object)cpu.getFlags());
    }
}

