/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.INC;
import emulator.unittest.hardware.nmos6502.MockOperand;
import org.junit.Assert;
import org.junit.Test;

public class INCTest {
    @Test
    public void testIncPositive() throws EmulatorException {
        this.executeAndCheckINC(63, 0);
    }

    @Test
    public void testIncNegative() throws EmulatorException {
        this.executeAndCheckINC(127, 128);
    }

    @Test
    public void testIncZero() throws EmulatorException {
        this.executeAndCheckINC(255, 2);
    }

    private void executeAndCheckINC(int val, int expected_flags) throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        MockOperand operand = new MockOperand(val);
        new INC().execute(cpu, operand);
        Assert.assertEquals((Object)new HwByte((long)(val + 1)), (Object)operand.getByte());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)cpu.getFlags());
    }
}

