/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.LSR;
import emulator.unittest.hardware.nmos6502.MockOperand;
import org.junit.Assert;
import org.junit.Test;

public class LSRTest {
    @Test
    public void testRotatePositive() throws EmulatorException {
        this.executeAndCheckLSR(0, 128, 0, 64);
    }

    @Test
    public void testRotateNegative() throws EmulatorException {
        this.executeAndCheckLSR(1, 0, 2, 0);
    }

    @Test
    public void testRotateZero() throws EmulatorException {
        this.executeAndCheckLSR(0, 1, 3, 0);
    }

    private void executeAndCheckLSR(int flags, int val, int expected_flags, int expected_val) throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        MockOperand operand = new MockOperand(val);
        cpu.setFlags(new Flags6502((long)flags));
        new LSR().execute(cpu, operand);
        Assert.assertEquals((Object)new HwByte((long)expected_val), (Object)operand.getByte());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)cpu.getFlags());
    }
}

