/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.nmos6502.commands.SBC;
import emulator.unittest.hardware.nmos6502.commands.CommandTestBase;
import org.junit.Before;
import org.junit.Test;

public class SBCTest
extends CommandTestBase {
    @Before
    public void setUp() {
        this.command = new SBC();
    }

    @Test
    public void testSubAllZero() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 1, 0, 0, 3, 0);
    }

    @Test
    public void testSubWithCarry() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 0, 0, 0, 128, 255);
    }

    @Test
    public void testSubExample213() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 1, 5, 3, 1, 2);
    }

    @Test
    public void testSubExample214() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 1, 5, 6, 128, 255);
    }

    @Test
    public void testSubExample216() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 1, 0, 255, 0, 1);
        this.executeAndCheckCommandOnAccu(this.command, 0, 2, 0, 1, 1);
    }

    @Test
    public void testSubExample217() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 1, 255, 0, 129, 255);
        this.executeAndCheckCommandOnAccu(this.command, 1, 0, 2, 128, 254);
    }

    @Test
    public void signedOverflowPositive() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 1, 127, 128, 192, 255);
    }

    @Test
    public void signedOverflowNegative() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 1, 128, 127, 65, 1);
    }

    @Test
    public void testDecimalModeFromZero() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 8, 0, 0, 136, 153);
        this.executeAndCheckCommandOnAccu(this.command, 9, 0, 0, 11, 0);
    }
}

