/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.TYA;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TYATest {
    private Cpu6502 cpu;
    private TYA tya;

    @Before
    public void setUp() throws Exception {
        this.cpu = new Cpu6502();
        this.tya = new TYA();
    }

    @Test
    public void testTransferZero() throws EmulatorException {
        this.executeAndcheckTYA(0, 2);
    }

    @Test
    public void testTransferPositive() throws EmulatorException {
        this.executeAndcheckTYA(5, 0);
    }

    @Test
    public void testTransferNegative() throws EmulatorException {
        this.executeAndcheckTYA(129, 128);
    }

    private void executeAndcheckTYA(int target, int expected_flags) throws EmulatorException {
        this.cpu.setY(new HwByte((long)target));
        this.cpu.setAccu(new HwByte(255L));
        this.tya.execute(this.cpu, new NoOperand());
        Assert.assertEquals((Object)new HwByte((long)target), (Object)this.cpu.getY());
        Assert.assertEquals((Object)new HwByte((long)target), (Object)this.cpu.getAccu());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)this.cpu.getFlags());
    }
}

