/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.timing;

import emulator.EmulatorException;
import emulator.unittest.hardware.nmos6502.timing.TimingTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbsoluteTest {
    TimingTestBase test_base = null;

    @Before
    public void setUp() throws Exception {
        this.test_base = new TimingTestBase();
    }

    @Test
    public void testADC() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(109));
    }

    @Test
    public void testAND() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(45));
    }

    @Test
    public void testASL() throws EmulatorException {
        Assert.assertEquals((long)6L, (long)this.getCycles(14));
    }

    @Test
    public void testBIT() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(44));
    }

    @Test
    public void testCMP() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(205));
    }

    @Test
    public void testCPX() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(236));
    }

    @Test
    public void testCPY() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(204));
    }

    @Test
    public void testDEC() throws EmulatorException {
        Assert.assertEquals((long)6L, (long)this.getCycles(206));
    }

    @Test
    public void testEOR() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(77));
    }

    @Test
    public void testINC() throws EmulatorException {
        Assert.assertEquals((long)6L, (long)this.getCycles(238));
    }

    @Test
    public void testJMP() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(76));
    }

    @Test
    public void testJSR() throws EmulatorException {
        Assert.assertEquals((long)6L, (long)this.getCycles(32));
    }

    @Test
    public void testLDA() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(173));
    }

    @Test
    public void testLDX() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(174));
    }

    @Test
    public void testLDY() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(172));
    }

    @Test
    public void testLSR() throws EmulatorException {
        Assert.assertEquals((long)6L, (long)this.getCycles(78));
    }

    @Test
    public void testORA() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(13));
    }

    @Test
    public void testROL() throws EmulatorException {
        Assert.assertEquals((long)6L, (long)this.getCycles(46));
    }

    @Test
    public void testROR() throws EmulatorException {
        Assert.assertEquals((long)6L, (long)this.getCycles(110));
    }

    @Test
    public void testSBC() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(237));
    }

    @Test
    public void testSTA() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(141));
    }

    @Test
    public void testSTX() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(142));
    }

    @Test
    public void testSTY() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(140));
    }

    private int getCycles(int opcode) throws EmulatorException {
        this.test_base.setCommand(0, opcode, 68, 1);
        this.test_base.execute();
        return this.test_base.getElapsedCycles();
    }
}

