/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.timing;

import emulator.EmulatorException;
import emulator.unittest.hardware.nmos6502.timing.TimingTestBase;
import org.junit.Assert;
import org.junit.Test;

public class RelativeTest {
    @Test
    public void testBCC() throws EmulatorException {
        int opcode = 144;
        int flag = 1;
        Assert.assertEquals((long)3L, (long)this.getCycles(opcode, 0, false));
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, 0, true));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, flag, false));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, flag, true));
    }

    @Test
    public void testBCS() throws EmulatorException {
        int opcode = 176;
        int flag = 1;
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, 0, false));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, 0, true));
        Assert.assertEquals((long)3L, (long)this.getCycles(opcode, flag, false));
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, flag, true));
    }

    @Test
    public void testBVC() throws EmulatorException {
        int opcode = 80;
        int flag = 64;
        Assert.assertEquals((long)3L, (long)this.getCycles(opcode, 0, false));
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, 0, true));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, flag, false));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, flag, true));
    }

    @Test
    public void testBVS() throws EmulatorException {
        int opcode = 112;
        int flag = 64;
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, 0, false));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, 0, true));
        Assert.assertEquals((long)3L, (long)this.getCycles(opcode, flag, false));
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, flag, true));
    }

    @Test
    public void testBPL() throws EmulatorException {
        int opcode = 16;
        int flag = 128;
        Assert.assertEquals((long)3L, (long)this.getCycles(opcode, 0, false));
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, 0, true));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, flag, false));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, flag, true));
    }

    @Test
    public void testBMI() throws EmulatorException {
        int opcode = 48;
        int flag = 128;
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, 0, false));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, 0, true));
        Assert.assertEquals((long)3L, (long)this.getCycles(opcode, flag, false));
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, flag, true));
    }

    @Test
    public void testBNE() throws EmulatorException {
        int opcode = 208;
        int flag = 2;
        Assert.assertEquals((long)3L, (long)this.getCycles(opcode, 0, false));
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, 0, true));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, flag, false));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, flag, true));
    }

    @Test
    public void testBEQ() throws EmulatorException {
        int opcode = 240;
        int flag = 2;
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, 0, false));
        Assert.assertEquals((long)2L, (long)this.getCycles(opcode, 0, true));
        Assert.assertEquals((long)3L, (long)this.getCycles(opcode, flag, false));
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, flag, true));
    }

    private int getCycles(int opcode, int flags, boolean cross_page) throws EmulatorException {
        TimingTestBase test_base = new TimingTestBase();
        test_base.setRegisters(0, 0, 0, flags);
        test_base.setCommand(cross_page ? 240 : 0, opcode, 112, 0);
        test_base.execute();
        return test_base.getElapsedCycles();
    }
}

