/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.timing;

import emulator.EmulatorException;
import emulator.unittest.hardware.nmos6502.timing.TimingTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZeroPageTest {
    TimingTestBase test_base = null;

    @Before
    public void setUp() throws Exception {
        this.test_base = new TimingTestBase();
    }

    @Test
    public void testADC() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(101));
    }

    @Test
    public void testAND() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(37));
    }

    @Test
    public void testASL() throws EmulatorException {
        Assert.assertEquals((long)5L, (long)this.getCycles(6));
    }

    @Test
    public void testBIT() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(36));
    }

    @Test
    public void testCMP() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(197));
    }

    @Test
    public void testCPX() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(228));
    }

    @Test
    public void testCPY() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(196));
    }

    @Test
    public void testDEC() throws EmulatorException {
        Assert.assertEquals((long)5L, (long)this.getCycles(198));
    }

    @Test
    public void testEOR() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(69));
    }

    @Test
    public void testINC() throws EmulatorException {
        Assert.assertEquals((long)5L, (long)this.getCycles(230));
    }

    @Test
    public void testLDA() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(165));
    }

    @Test
    public void testLDX() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(166));
    }

    @Test
    public void testLDY() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(164));
    }

    @Test
    public void testLSR() throws EmulatorException {
        Assert.assertEquals((long)5L, (long)this.getCycles(70));
    }

    @Test
    public void testORA() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(5));
    }

    @Test
    public void testROL() throws EmulatorException {
        Assert.assertEquals((long)5L, (long)this.getCycles(38));
    }

    @Test
    public void testROR() throws EmulatorException {
        Assert.assertEquals((long)5L, (long)this.getCycles(102));
    }

    @Test
    public void testSBC() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(229));
    }

    @Test
    public void testSTA() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(133));
    }

    @Test
    public void testSTX() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(134));
    }

    @Test
    public void testSTY() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(132));
    }

    private int getCycles(int opcode) throws EmulatorException {
        this.test_base.setCommand(0, opcode, 68, 0);
        this.test_base.execute();
        return this.test_base.getElapsedCycles();
    }
}

