/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.video;

import emulator.EmulatorException;
import emulator.GUI.display.VicDisplay;
import emulator.hardware.bus.VideoBus;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.video.Vic6561;
import emulator.hardware.video.test.CountingClock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class Vic6561Test {
    private static final int PAL_SCREEN_TICKS = 22152;
    private Vic6561 vic;
    private CountingClock clock;
    private MemoryBlock memory;
    private VicDisplay display;

    @Before
    public void setUp() throws Exception {
        this.vic = new Vic6561();
        this.clock = new CountingClock();
        this.memory = new MemoryBlock(65536);
        this.vic.attach(new VideoBus(this.memory), this.clock);
        this.display = (VicDisplay)Mockito.mock(VicDisplay.class);
    }

    @Test
    public void testRefreshDisplayTimingDefault() throws EmulatorException {
        this.vic.refreshDisplay(this.display);
        Assert.assertEquals((long)22152L, (long)this.clock.getCounterValue());
    }

    @Test
    public void testRefreshDisplayTimingWide() throws EmulatorException {
        this.vic.write(0, 8);
        this.vic.write(1, 21);
        this.vic.write(2, 26);
        this.vic.write(3, this.vic.read(3) & 0x80 | 0x21);
        this.vic.write(5, 204);
        this.vic.refreshDisplay(this.display);
        Assert.assertEquals((long)22152L, (long)this.clock.getCounterValue());
    }
}

