/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.support;

import emulator.support.AbsoluteOperandEval;
import emulator.support.AbsoluteXOperandEval;
import emulator.support.AbsoluteYOperandEval;
import emulator.support.CpuState;
import emulator.support.DisplacementOperandEval;
import emulator.support.ImmediateAddressOperandEval;
import emulator.support.IndirectAddressOperandEval;
import emulator.support.IndirectXOperandEval;
import emulator.support.IndirectYOperandEval;
import emulator.support.ZeroPageOperandEval;
import emulator.support.ZeroPageXOperandEval;
import emulator.support.ZeroPageYOperandEval;
import emulator.util.MemoryPtr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OperandEvalTest {
    private byte[] memory;
    private CpuState cpu_state;

    @Before
    public void setUp() throws Exception {
        this.memory = new byte[65536];
        int i = 0;
        while (i < this.memory.length) {
            this.memory[i] = (byte)(i & 0xFF);
            ++i;
        }
        this.cpu_state = new CpuState();
        this.cpu_state.setValue("A", 10);
        this.cpu_state.setValue("X", 20);
        this.cpu_state.setValue("Y", 30);
        this.cpu_state.setValue("PC", 40);
        this.cpu_state.setValue("SP", 50);
        this.cpu_state.setValue("Flags", 96);
    }

    @Test
    public void testAbsoluteOperandGetDetails() {
        Assert.assertEquals((Object)"($0201) -> $01", (Object)new AbsoluteOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($0504) -> $04", (Object)new AbsoluteOperandEval(new MemoryPtr(this.memory, 3)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($0100) -> $00", (Object)new AbsoluteOperandEval(new MemoryPtr(this.memory, 65535)).getDetails(this.cpu_state));
    }

    @Test
    public void testAbsoluteXOperandGetDetails() {
        Assert.assertEquals((Object)"($0201 + $14) -> $15", (Object)new AbsoluteXOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($0504 + $14) -> $18", (Object)new AbsoluteXOperandEval(new MemoryPtr(this.memory, 3)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($0100 + $14) -> $14", (Object)new AbsoluteXOperandEval(new MemoryPtr(this.memory, 65535)).getDetails(this.cpu_state));
    }

    @Test
    public void testAbsoluteYOperandGetDetails() {
        Assert.assertEquals((Object)"($0201 + $1E) -> $1F", (Object)new AbsoluteYOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($0504 + $1E) -> $22", (Object)new AbsoluteYOperandEval(new MemoryPtr(this.memory, 3)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($0100 + $1E) -> $1E", (Object)new AbsoluteYOperandEval(new MemoryPtr(this.memory, 65535)).getDetails(this.cpu_state));
    }

    @Test
    public void testDisplacementOperandGetDetails() {
        Assert.assertEquals((Object)"PC + $01 -> $0003", (Object)new DisplacementOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"PC + $81 -> $0003", (Object)new DisplacementOperandEval(new MemoryPtr(this.memory, 128)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"PC + $00 -> $0001", (Object)new DisplacementOperandEval(new MemoryPtr(this.memory, 65535)).getDetails(this.cpu_state));
    }

    @Test
    public void testImmediateAddressOperandGetDetails() {
        Assert.assertEquals((Object)"$0201", (Object)new ImmediateAddressOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"$0504", (Object)new ImmediateAddressOperandEval(new MemoryPtr(this.memory, 3)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"$0100", (Object)new ImmediateAddressOperandEval(new MemoryPtr(this.memory, 65535)).getDetails(this.cpu_state));
    }

    @Test
    public void testIndirectAddressOperandGetDetails() {
        Assert.assertEquals((Object)"($0201) -> $0201", (Object)new IndirectAddressOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($0504) -> $0504", (Object)new IndirectAddressOperandEval(new MemoryPtr(this.memory, 3)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($0100) -> $0100", (Object)new IndirectAddressOperandEval(new MemoryPtr(this.memory, 65535)).getDetails(this.cpu_state));
    }

    @Test
    public void testIndirectXOperandGetDetails() {
        Assert.assertEquals((Object)"(($01 + $14 -> $15) -> $1615) -> $15", (Object)new IndirectXOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"(($04 + $14 -> $18) -> $1918) -> $18", (Object)new IndirectXOperandEval(new MemoryPtr(this.memory, 3)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"(($FF + $14 -> $13) -> $1413) -> $13", (Object)new IndirectXOperandEval(new MemoryPtr(this.memory, 65534)).getDetails(this.cpu_state));
    }

    @Test
    public void testIndirectYOperandGetDetails() {
        Assert.assertEquals((Object)"(($01) + Y -> $0201 + $1E -> $021F) -> $1F", (Object)new IndirectYOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"(($04) + Y -> $0504 + $1E -> $0522) -> $22", (Object)new IndirectYOperandEval(new MemoryPtr(this.memory, 3)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"(($00) + Y -> $0100 + $1E -> $011E) -> $1E", (Object)new IndirectYOperandEval(new MemoryPtr(this.memory, 65535)).getDetails(this.cpu_state));
    }

    @Test
    public void testZeroPageOperandGetDetails() {
        Assert.assertEquals((Object)"($01) -> $01", (Object)new ZeroPageOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($04) -> $04", (Object)new ZeroPageOperandEval(new MemoryPtr(this.memory, 3)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($00) -> $00", (Object)new ZeroPageOperandEval(new MemoryPtr(this.memory, 65535)).getDetails(this.cpu_state));
    }

    @Test
    public void testZeroPageXOperandGetDetails() {
        Assert.assertEquals((Object)"($01 + $14) -> $15", (Object)new ZeroPageXOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($F4 + $14) -> $08", (Object)new ZeroPageXOperandEval(new MemoryPtr(this.memory, 243)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($00 + $14) -> $14", (Object)new ZeroPageXOperandEval(new MemoryPtr(this.memory, 65535)).getDetails(this.cpu_state));
    }

    @Test
    public void testZeroPageYOperandGetDetails() {
        Assert.assertEquals((Object)"($01 + $1E) -> $1F", (Object)new ZeroPageYOperandEval(new MemoryPtr(this.memory, 0)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($F4 + $1E) -> $12", (Object)new ZeroPageYOperandEval(new MemoryPtr(this.memory, 243)).getDetails(this.cpu_state));
        Assert.assertEquals((Object)"($00 + $1E) -> $1E", (Object)new ZeroPageYOperandEval(new MemoryPtr(this.memory, 65535)).getDetails(this.cpu_state));
    }
}

