/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.util;

import emulator.util.MemoryPtr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryPtrTest {
    private byte[] memory;
    private MemoryPtr ptr0;
    private MemoryPtr ptr1;
    private MemoryPtr ptr2;

    @Before
    public void setUp() throws Exception {
        this.memory = new byte[]{1, -14, 3, -12, 5};
        this.ptr0 = new MemoryPtr(this.memory, 0);
        this.ptr1 = new MemoryPtr(this.memory, 1);
        this.ptr2 = new MemoryPtr(this.memory, 2);
    }

    @Test
    public void testGet() {
        byte[] bytes = new byte[3];
        this.ptr0.get(bytes);
        Assert.assertEquals((long)this.memory[0], (long)bytes[0]);
        Assert.assertEquals((long)this.memory[1], (long)bytes[1]);
        Assert.assertEquals((long)this.memory[2], (long)bytes[2]);
        this.ptr1.get(bytes);
        Assert.assertEquals((long)this.memory[1], (long)bytes[0]);
        Assert.assertEquals((long)this.memory[2], (long)bytes[1]);
        Assert.assertEquals((long)this.memory[3], (long)bytes[2]);
        this.ptr2.get(bytes);
        Assert.assertEquals((long)this.memory[2], (long)bytes[0]);
        Assert.assertEquals((long)this.memory[3], (long)bytes[1]);
        Assert.assertEquals((long)this.memory[4], (long)bytes[2]);
    }

    @Test
    public void testGetWordOp() {
        Assert.assertEquals((long)1010L, (long)this.ptr0.getWordOp());
        Assert.assertEquals((long)62467L, (long)this.ptr1.getWordOp());
        Assert.assertEquals((long)1524L, (long)this.ptr2.getWordOp());
    }

    @Test
    public void testGetByteOp() {
        Assert.assertEquals((long)242L, (long)this.ptr0.getByteOp());
        Assert.assertEquals((long)3L, (long)this.ptr1.getByteOp());
        Assert.assertEquals((long)244L, (long)this.ptr2.getByteOp());
    }

    @Test
    public void testGetRelativeOp() {
        Assert.assertEquals((long)-12L, (long)this.ptr0.getRelativeOp());
        Assert.assertEquals((long)6L, (long)this.ptr1.getRelativeOp());
        Assert.assertEquals((long)-8L, (long)this.ptr2.getRelativeOp());
    }
}

