/*
 * Decompiled with CFR 0.152.
 */
package emulator.util;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.bus.Bus;
import java.io.PrintStream;

public class AddressRange {
    int start = 0;
    int end = 0;

    public AddressRange(int start, int end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public AddressRange() {
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public static AddressRange fromString(String string) {
        AddressRange result = new AddressRange();
        String[] addresses = string.split("-");
        result.setStart(AddressRange.addressFromString(addresses[0]));
        if (addresses.length > 1) {
            result.setEnd(AddressRange.addressFromString(addresses[1]));
        } else {
            result.setEnd(AddressRange.addressFromString(addresses[0]));
        }
        return result;
    }

    public static int addressFromString(String string) {
        if (string.length() > 0) {
            if (string.charAt(0) == '$') {
                String ucstr = string.toUpperCase();
                String digits = "0123456789ABCDEF";
                int val = 0;
                int i = 1;
                while (i < ucstr.length()) {
                    val <<= 4;
                    int digit = digits.indexOf(ucstr.charAt(i));
                    if (digit < 0) {
                        throw new NumberFormatException(string);
                    }
                    val |= digit;
                    ++i;
                }
                return val;
            }
            if (string.charAt(0) == '%') {
                int val = 0;
                int i = 1;
                while (i < string.length()) {
                    val <<= 1;
                    if (string.charAt(i) == '1') {
                        val |= 1;
                    } else if (string.charAt(i) != '0') {
                        throw new NumberFormatException(string);
                    }
                    ++i;
                }
                return val;
            }
            return Integer.parseInt(string);
        }
        return 0;
    }

    public void printMemory(Bus bus, PrintStream out) {
        int first_line = this.getStart() & 0xFFFFFFF0;
        int last_line = this.getEnd() & 0xFFFFFFF0;
        int line = first_line;
        while (line <= last_line) {
            String text = new String();
            HwWord base = new HwWord((long)line);
            out.print(String.valueOf(base.toString()) + ":  ");
            int i = 0;
            while (i < 16) {
                if (base.getNumber() < (long)this.getStart() || base.getNumber() > (long)this.getEnd()) {
                    out.print("   ");
                    text = String.valueOf(text) + " ";
                } else {
                    try {
                        HwByte data = new HwByte((long)bus.read((int)base.getNumber()));
                        out.print(String.valueOf(data.toString()) + " ");
                        text = data.getNumber() >= 32L && data.getNumber() < 128L ? String.valueOf(text) + (char)data.getNumber() : String.valueOf(text) + ".";
                    }
                    catch (EmulatorException e) {
                        out.print("?? ");
                        text = String.valueOf(text) + ".";
                    }
                }
                base.inc(1);
                ++i;
            }
            out.println(" " + text);
            line += 16;
        }
    }

    public String toString() {
        return "$" + new HwWord((long)this.getStart()) + " - $" + new HwWord((long)this.getEnd());
    }

    public boolean contains(int address) {
        return this.getStart() <= address && address <= this.getEnd();
    }

    public int getWidth() {
        return this.getEnd() + 1 - this.getStart();
    }

    public static String toBinaryString(int value, int len) {
        String binaryString = Integer.toBinaryString(value);
        while (binaryString.length() < len) {
            binaryString = "0" + binaryString;
        }
        return binaryString;
    }
}

