/*
 * Decompiled with CFR 0.152.
 */
package emulator.util;

import emulator.hardware.memory.MemoryBlockInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayWrapper
implements MemoryBlockInterface {
    private byte[] data;

    public ByteArrayWrapper(byte[] data) {
        this.data = data;
    }

    @Override
    public void loadFromStream(InputStream file, int address, int size) throws IOException {
        int i = 0;
        while (i < size) {
            int ch = file.read();
            if (ch < 0) {
                return;
            }
            this.data[address + i] = (byte)ch;
            ++i;
        }
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void saveToStream(OutputStream file, int address, int size) throws IOException {
        file.write(this.data, address, size);
    }
}

