/*
 * Decompiled with CFR 0.152.
 */
package emulator.util.file;

import emulator.util.AddressRange;
import emulator.util.file.FileHelper;
import emulator.util.file.FileInfo;
import emulator.util.file.FileLoadStrategy;
import emulator.util.file.FileLoadStrategyRaw;
import emulator.util.file.FileSaveStrategy;
import emulator.util.file.FileSaveStrategyRaw;
import java.io.File;

public class FileInfoRaw
implements FileInfo {
    private int block_size;
    private int start_address;

    public FileInfoRaw(String file_name) {
        File file = new File(file_name);
        this.block_size = (int)file.length();
        this.start_address = -1;
        String file_extension = FileHelper.getFileExtension(file_name);
        if (file_extension.length() == 2 || file_extension.length() == 4) {
            try {
                int address = AddressRange.addressFromString("$" + file_extension);
                if (file_extension.length() == 2) {
                    address <<= 8;
                }
                this.start_address = address;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getBlockSize() {
        return this.block_size;
    }

    @Override
    public int getFormat() {
        return 1;
    }

    @Override
    public int getStartAddress() {
        return this.start_address;
    }

    @Override
    public FileLoadStrategy getLoadStrategy() {
        return new FileLoadStrategyRaw();
    }

    @Override
    public FileSaveStrategy getSaveStrategy() {
        return new FileSaveStrategyRaw();
    }
}

