/*
 * Decompiled with CFR 0.152.
 */
package emulator.util.file;

import emulator.hardware.memory.MemoryBlockInterface;
import emulator.shell.DebugShell;
import emulator.util.file.FileLoadStrategy;
import java.io.FileInputStream;
import java.io.IOException;

public class FileLoadStrategySkipPrefix
implements FileLoadStrategy {
    int prefix;

    public FileLoadStrategySkipPrefix(int prefix_size) {
        this.prefix = prefix_size;
    }

    @Override
    public void loadToMemory(String file_name, MemoryBlockInterface memory, int start_address, int block_size) {
        block13: {
            FileInputStream file = null;
            try {
                try {
                    file = new FileInputStream(file_name);
                    int i = 0;
                    while (i < this.prefix) {
                        file.read();
                        ++i;
                    }
                    memory.loadFromStream(file, start_address, block_size);
                }
                catch (IOException e) {
                    DebugShell.getInstance().getErr().println("File read failed for \"" + file_name + "\" (prg): " + e.getMessage());
                    if (file == null) break block13;
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

