/*
 * Decompiled with CFR 0.152.
 */
package sidconverter.gui;

import emulator.sidplay.SidVicCon;
import emulator.util.file.FileHelper;
import emulator.util.file.FileInfo;
import emulator.util.file.FileInfoSid;
import emulator.util.file.FileLoadStrategy;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import sidconverter.gui.AnalyzerFrame;

public class SidConverter {
    private JFrame frmViciousSidConverter;
    private JTextField textSidSource;
    private JTextField textSidTitle;
    private JTextField textSidAuthor;
    private JTextField textSidYear;
    private JTextField textSidSongs;
    private JTextField textSidStart;
    private JTextField textPrgFile;
    private JTextField textLblFile;
    private JTextField textOutputPrg;
    private Preferences cfg = Preferences.userNodeForPackage(this.getClass());
    private JFileChooser fileChooserSid;
    private JFileChooser fileChooserEmu;
    private JFileChooser fileChooserOut;
    private JComboBox comboSongNo;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SidConverter window = new SidConverter();
                    window.frmViciousSidConverter.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SidConverter() {
        this.initialize();
        this.fileChooserSid = new JFileChooser();
        this.fileChooserEmu = new JFileChooser();
        this.fileChooserOut = new JFileChooser();
        this.loadSettings();
    }

    private void initialize() {
        this.frmViciousSidConverter = new JFrame();
        this.frmViciousSidConverter.setTitle("Vicious SID Converter");
        this.frmViciousSidConverter.setBounds(100, 100, 440, 482);
        this.frmViciousSidConverter.setDefaultCloseOperation(3);
        JLabel lblSource = new JLabel("Source:");
        lblSource.setFont(new Font("Tahoma", 1, 13));
        JLabel lblSid = new JLabel("SID");
        this.textSidSource = new JTextField();
        this.textSidSource.setColumns(10);
        JButton btnBrowseSid = new JButton("Browse...");
        btnBrowseSid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selected_file = SidConverter.this.openFileDialog("Load SID", "sid", 0, SidConverter.this.fileChooserSid);
                if (selected_file != null) {
                    SidConverter.this.textSidSource.setText(selected_file);
                    if (!selected_file.isEmpty()) {
                        SidConverter.this.updateSid();
                    }
                }
            }
        });
        JLabel lblTitle = new JLabel("Title");
        JLabel lblAuthor = new JLabel("Author");
        JLabel lblYear = new JLabel("Year");
        JLabel lblSongs = new JLabel("Songs");
        JLabel lblDefault = new JLabel("Default");
        this.textSidTitle = new JTextField();
        this.textSidTitle.setEditable(false);
        this.textSidTitle.setColumns(10);
        this.textSidAuthor = new JTextField();
        this.textSidAuthor.setEditable(false);
        this.textSidAuthor.setColumns(10);
        this.textSidYear = new JTextField();
        this.textSidYear.setEditable(false);
        this.textSidYear.setColumns(10);
        this.textSidSongs = new JTextField();
        this.textSidSongs.setEditable(false);
        this.textSidSongs.setColumns(10);
        this.textSidStart = new JTextField();
        this.textSidStart.setEditable(false);
        this.textSidStart.setColumns(10);
        JLabel lblSidVicious = new JLabel("SID Vicious:");
        lblSidVicious.setFont(new Font("Tahoma", 1, 13));
        JLabel lblPrg = new JLabel("PRG");
        JLabel lblLbl = new JLabel("LBL");
        this.textPrgFile = new JTextField();
        this.textPrgFile.setColumns(10);
        this.textLblFile = new JTextField();
        this.textLblFile.setColumns(10);
        JButton btnBrowsePrg = new JButton("Browse...");
        btnBrowsePrg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selected_file = SidConverter.this.openFileDialog("Load SID Visious", "prg", 0, SidConverter.this.fileChooserEmu);
                if (selected_file != null) {
                    SidConverter.this.textPrgFile.setText(selected_file);
                    SidConverter.this.updatePrg();
                }
            }
        });
        JButton btnBrowseLbl = new JButton("Browse...");
        btnBrowseLbl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selected_file = SidConverter.this.openFileDialog("Load Symbols", "lbl", 0, SidConverter.this.fileChooserEmu);
                if (selected_file != null) {
                    SidConverter.this.textLblFile.setText(selected_file);
                    SidConverter.this.updateLbl();
                }
            }
        });
        JButton btnAnalyze = new JButton("Analyze...");
        btnAnalyze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SidConverter.this.onAnalyze();
            }
        });
        JButton btnConvert = new JButton("Convert...");
        btnConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SidConverter.this.onConvert();
            }
        });
        JLabel lblOutput = new JLabel("Output:");
        lblOutput.setFont(new Font("Tahoma", 1, 13));
        JLabel lblPrg_1 = new JLabel("PRG");
        this.textOutputPrg = new JTextField();
        this.textOutputPrg.setColumns(10);
        JButton btnBrowseOutputPrg = new JButton("Browse...");
        btnBrowseOutputPrg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selected_file = SidConverter.this.openFileDialog("Output program", "prg", 1, SidConverter.this.fileChooserOut);
                if (selected_file != null) {
                    SidConverter.this.textOutputPrg.setText(selected_file);
                    SidConverter.this.updateOutput();
                }
            }
        });
        JLabel lblSong = new JLabel("Song");
        this.comboSongNo = new JComboBox();
        GroupLayout groupLayout = new GroupLayout(this.frmViciousSidConverter.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lblPrg).addComponent(lblLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textPrgFile, GroupLayout.Alignment.TRAILING, -1, 259, Short.MAX_VALUE).addComponent(this.textLblFile, GroupLayout.Alignment.TRAILING, -1, 259, Short.MAX_VALUE).addComponent(btnConvert, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(btnBrowseLbl).addComponent(btnBrowsePrg))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lblSid).addComponent(lblTitle)).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.textSidSource, -1, 253, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnBrowseSid).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addComponent(this.textSidTitle, -1, 346, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lblYear).addComponent(lblAuthor).addComponent(lblSongs)).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.textSidSongs, -2, -1, -2).addGap(46).addComponent(lblDefault).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textSidStart, -2, -1, -2)).addComponent(this.textSidAuthor, 332, 332, 332).addComponent(this.textSidYear, 332, 332, 332))).addGroup(groupLayout.createSequentialGroup().addGap(36).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboSongNo, -2, 52, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.textOutputPrg, -1, 259, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnBrowseOutputPrg))))).addGap(115)).addGroup(groupLayout.createSequentialGroup().addGap(98).addComponent(btnAnalyze)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(lblOutput)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(lblPrg_1))).addGap(0)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(lblSource).addContainerGap(453, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(lblSidVicious).addContainerGap(427, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(lblSong).addContainerGap(357, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(lblSource).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblSid).addComponent(this.textSidSource, -2, -1, -2).addComponent(btnBrowseSid, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblTitle).addComponent(this.textSidTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblAuthor).addComponent(this.textSidAuthor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblYear).addComponent(this.textSidYear, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblSongs).addComponent(lblDefault).addComponent(this.textSidSongs, -2, -1, -2).addComponent(this.textSidStart, -2, -1, -2)).addGap(18).addComponent(lblSidVicious).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblPrg).addComponent(this.textPrgFile, -2, -1, -2).addComponent(btnBrowsePrg)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblLbl).addComponent(this.textLblFile, -2, -1, -2).addComponent(btnBrowseLbl)).addGap(18).addComponent(lblOutput).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblPrg_1).addComponent(btnBrowseOutputPrg).addComponent(this.textOutputPrg, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblSong).addComponent(this.comboSongNo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(btnAnalyze).addComponent(btnConvert)).addContainerGap()));
        this.frmViciousSidConverter.getContentPane().setLayout(groupLayout);
    }

    private void loadSettings() {
        File prg;
        this.fileChooserSid.setCurrentDirectory(new File(this.cfg.get("SidDir", this.fileChooserSid.getCurrentDirectory().getAbsolutePath())));
        this.fileChooserEmu.setCurrentDirectory(new File(this.cfg.get("EmuDir", this.fileChooserEmu.getCurrentDirectory().getAbsolutePath())));
        this.fileChooserOut.setCurrentDirectory(new File(this.cfg.get("OutDir", this.fileChooserOut.getCurrentDirectory().getAbsolutePath())));
        String prg_file = "";
        String lbl_file = this.cfg.get("SourceLbl", "");
        if (prg_file.isEmpty() && (prg = new File("sidplay.prg")).canRead() && prg.isFile()) {
            prg_file = prg.getAbsolutePath();
            lbl_file = "";
        }
        this.textPrgFile.setText(prg_file);
        this.textLblFile.setText(lbl_file);
        if (!prg_file.isEmpty()) {
            if (lbl_file.isEmpty()) {
                this.updatePrg();
            } else {
                this.updateLbl();
            }
        }
    }

    private void saveSettings() {
        this.saveIfNotEmpty("SourcePrg", this.textPrgFile.getText());
        this.saveIfNotEmpty("SourceLbl", this.textLblFile.getText());
        this.saveIfNotEmpty("SidDir", this.fileChooserSid.getCurrentDirectory().getAbsolutePath());
        this.saveIfNotEmpty("EmuDir", this.fileChooserEmu.getCurrentDirectory().getAbsolutePath());
        this.saveIfNotEmpty("OutDir", this.fileChooserOut.getCurrentDirectory().getAbsolutePath());
    }

    private void saveIfNotEmpty(String key, String value) {
        if (value != null && !value.isEmpty()) {
            this.cfg.put(key, value);
        }
    }

    private String openFileDialog(String title, final String ext, int type, JFileChooser fileChooser) {
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().matches(".*\\." + ext);
            }

            @Override
            public String getDescription() {
                return "*." + ext;
            }
        });
        if (type == 0) {
            fileChooser.showOpenDialog(null);
        } else {
            fileChooser.showSaveDialog(null);
        }
        if (fileChooser.getSelectedFile() != null) {
            return fileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    protected void updateSid() {
        int song_count = 0;
        int default_song = 0;
        String sid_name = this.textSidSource.getText();
        FileInfo info = FileHelper.getFileInfo(sid_name, FileHelper.guessFileFormat(sid_name));
        if (info == null) {
            JOptionPane.showMessageDialog(this.frmViciousSidConverter, "Unknown file format or file not found.");
        } else if (info.getStartAddress() < 0) {
            JOptionPane.showMessageDialog(this.frmViciousSidConverter, "Unknown load address.");
        } else {
            FileLoadStrategy loader = info.getLoadStrategy();
            if (loader == null) {
                JOptionPane.showMessageDialog(this.frmViciousSidConverter, "Unsupported file format.");
            } else {
                FileInfoSid sid_file = null;
                try {
                    sid_file = (FileInfoSid)info;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (sid_file != null) {
                    this.textSidTitle.setText(sid_file.getTitle());
                    this.textSidAuthor.setText(sid_file.getAuthor());
                    this.textSidYear.setText(sid_file.getYear());
                    this.textSidSongs.setText(Integer.toString(sid_file.getSongCount()));
                    this.textSidStart.setText(Integer.toString(sid_file.getStartSong()));
                    default_song = sid_file.getStartSong();
                    song_count = sid_file.getSongCount();
                }
            }
        }
        this.setSongCount(song_count, default_song);
        this.saveSettings();
    }

    protected void updatePrg() {
        String lbl_name;
        File lbl_file;
        String prg_name = this.textPrgFile.getText();
        int dot_pos = prg_name.lastIndexOf(46);
        if (dot_pos >= 0 && (lbl_file = new File(lbl_name = String.valueOf(prg_name.substring(0, dot_pos + 1)) + "lbl")).isFile() && lbl_file.canRead()) {
            this.textLblFile.setText(lbl_name);
            this.updateLbl();
        }
    }

    protected void updateLbl() {
        this.saveSettings();
    }

    protected void updateOutput() {
        this.saveSettings();
    }

    protected void onAnalyze() {
        AnalyzerFrame frame = new AnalyzerFrame();
        frame.restorePosition();
        frame.setVisible(true);
        new Thread(frame){
            PrintStream out;
            PrintStream err;
            {
                this.out = analyzerFrame.createOut();
                this.err = analyzerFrame.createErr();
            }

            @Override
            public void run() {
                SidConverter.this.onBeginAnalysis();
                SidVicCon.convertSid(SidConverter.this.getSongNo(), SidConverter.this.getSongNo(), SidConverter.this.textSidSource.getText(), SidConverter.this.textPrgFile.getText(), SidConverter.this.textLblFile.getText(), null, this.out, this.err);
                SidConverter.this.onEndAnalysis();
            }
        }.start();
    }

    protected void onConvert() {
        String output_name = this.textOutputPrg.getText();
        if (output_name.isEmpty()) {
            JOptionPane.showMessageDialog(this.frmViciousSidConverter, "Output file name is empty!");
        } else {
            AnalyzerFrame frame = new AnalyzerFrame();
            frame.restorePosition();
            frame.setVisible(true);
            new Thread(frame){
                PrintStream out;
                PrintStream err;
                {
                    this.out = analyzerFrame.createOut();
                    this.err = analyzerFrame.createErr();
                }

                @Override
                public void run() {
                    SidConverter.this.onBeginAnalysis();
                    SidVicCon.convertSid(SidConverter.this.getSongNo(), SidConverter.this.getSongNo(), SidConverter.this.textSidSource.getText(), SidConverter.this.textPrgFile.getText(), SidConverter.this.textLblFile.getText(), SidConverter.this.textOutputPrg.getText(), this.out, this.err);
                    SidConverter.this.onEndAnalysis();
                }
            }.start();
        }
    }

    private void setSongCount(int song_count, int default_song) {
        this.comboSongNo.removeAllItems();
        int i = 0;
        while (i <= song_count) {
            this.comboSongNo.addItem(Integer.toString(i));
            ++i;
        }
        this.comboSongNo.setSelectedIndex(default_song);
    }

    protected int getSongNo() {
        int song_no = this.comboSongNo.getSelectedIndex();
        return song_no > 0 ? song_no : 0;
    }

    protected void onBeginAnalysis() {
        this.frmViciousSidConverter.setEnabled(false);
    }

    protected void onEndAnalysis() {
        this.frmViciousSidConverter.setEnabled(true);
    }
}

