/*
 * Decompiled with CFR 0.152.
 */
package com.jhe.hexed;

import com.jhe.hexed.ClipboardInterface;
import com.jhe.hexed.JHexEditorASCII;
import com.jhe.hexed.JHexEditorData;
import com.jhe.hexed.JHexEditorHEX;
import com.jhe.hexed.JHexEditorSelection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JHexEditor
extends JPanel
implements FocusListener,
AdjustmentListener,
MouseWheelListener {
    static Logger logger = LogManager.getLogger((String)JHexEditor.class.getName());
    public JHexEditorData data = null;
    protected static Font font = new Font("Monospaced", 0, 12);
    protected int border = 2;
    public boolean DEBUG = false;
    private JPanel panel;
    private JScrollBar sb;
    private int inicio = 0;
    private int lineas = 10;
    ClipboardInterface clipboard = null;
    public JHexEditorSelection selectionData = new JHexEditorSelection();
    private String logLine = "";

    public JHexEditor(byte[] buff, ClipboardInterface clipboard) {
        this.data = new JHexEditorData(buff);
        this.data.setBufferView(0, buff.length);
        this.clipboard = clipboard;
        this.addMouseWheelListener(this);
        this.sb = new JScrollBar(1);
        this.sb.addAdjustmentListener(this);
        this.sb.setMinimum(0);
        this.sb.setMaximum(buff.length / this.getLineas());
        JPanel p1 = new JPanel(new BorderLayout(1, 1));
        p1.add((Component)new JHexEditorHEX(this), "Center");
        p1.add((Component)new Columnas(), "North");
        JPanel p2 = new JPanel(new BorderLayout(1, 1));
        p2.add((Component)new Filas(), "Center");
        p2.add((Component)new Caja(), "North");
        JPanel p3 = new JPanel(new BorderLayout(1, 1));
        p3.add((Component)this.sb, "East");
        p3.add((Component)new JHexEditorASCII(this), "Center");
        p3.add((Component)new Caja(), "North");
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(1, 1));
        this.panel.add((Component)p1, "Center");
        this.panel.add((Component)p2, "West");
        this.panel.add((Component)p3, "East");
        this.setLayout(new BorderLayout(1, 1));
        this.add((Component)this.panel, "Center");
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics fn = this.getFontMetrics(font);
        Rectangle rec = this.getBounds();
        this.lineas = rec.height / fn.getHeight() - 1;
        int n = this.data.getBufferLength() / 16 - 1;
        if (this.lineas > n) {
            this.lineas = n;
            this.inicio = 0;
        }
        this.sb.setValues(this.getInicio(), this.getLineas(), 0, this.data.getBufferLength() / 16);
        this.sb.setValueIsAdjusting(true);
        super.paint(g);
    }

    protected void actualizaCursor() {
        int n = this.selectionData.cursor / 16;
        this.debugPrint("- " + this.inicio + "<" + n + "<" + (this.lineas + this.inicio) + "(" + this.lineas + ")");
        if (n < this.inicio) {
            this.inicio = n;
        } else if (n >= this.inicio + this.lineas) {
            this.inicio = n - (this.lineas - 1);
        }
        this.debugPrintLine(" - " + this.inicio + "<" + n + "<" + (this.lineas + this.inicio) + "(" + this.lineas + ")");
        if (this.selectionData.isInSelection()) {
            this.selectionData.updateSelection(this.selectionData.cursor);
        }
        this.repaint();
    }

    protected void debugPrintLine(String debugString) {
        if (this.DEBUG) {
            logger.debug(String.valueOf(this.logLine) + debugString);
        }
        this.logLine = "";
    }

    protected void debugPrint(String debugString) {
        if (this.DEBUG) {
            this.logLine = String.valueOf(this.logLine) + debugString;
        }
    }

    protected int getInicio() {
        return this.inicio;
    }

    protected int getLineas() {
        return this.lineas;
    }

    protected void fondo(Graphics g, int x, int y, int s) {
        FontMetrics fn = this.getFontMetrics(font);
        g.fillRect((fn.stringWidth(" ") + 1) * x + this.border, fn.getHeight() * y + this.border, (fn.stringWidth(" ") + 1) * s, fn.getHeight() + 1);
    }

    protected void cuadro(Graphics g, int x, int y, int s) {
        FontMetrics fn = this.getFontMetrics(font);
        g.drawRect((fn.stringWidth(" ") + 1) * x + this.border, fn.getHeight() * y + this.border, (fn.stringWidth(" ") + 1) * s, fn.getHeight() + 1);
    }

    protected void printString(Graphics g, String s, int x, int y) {
        FontMetrics fn = this.getFontMetrics(font);
        g.drawString(s, (fn.stringWidth(" ") + 1) * x + this.border, fn.getHeight() * (y + 1) - fn.getMaxDescent() + this.border);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.inicio = e.getValue();
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.inicio += e.getUnitsToScroll();
        if (this.inicio + this.lineas >= this.data.getBufferLength() / 16) {
            this.inicio = this.data.getBufferLength() / 16 - this.lineas;
        }
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 33: {
                if (this.selectionData.cursor >= 16 * this.lineas) {
                    this.selectionData.cursor -= 16 * this.lineas;
                }
                this.actualizaCursor();
                break;
            }
            case 34: {
                if (this.selectionData.cursor < this.data.getBufferLength() - 16 * this.lineas) {
                    this.selectionData.cursor += 16 * this.lineas;
                }
                this.actualizaCursor();
                break;
            }
            case 35: {
                this.selectionData.cursor = this.data.getBufferLength() - 1;
                this.actualizaCursor();
                break;
            }
            case 36: {
                this.selectionData.cursor = 0;
                this.actualizaCursor();
                break;
            }
            case 37: {
                if (this.selectionData.cursor != 0) {
                    --this.selectionData.cursor;
                }
                this.actualizaCursor();
                break;
            }
            case 38: {
                if (this.selectionData.cursor > 15) {
                    this.selectionData.cursor -= 16;
                }
                this.actualizaCursor();
                break;
            }
            case 39: {
                if (this.selectionData.cursor != this.data.getBufferLength() - 1) {
                    ++this.selectionData.cursor;
                }
                this.actualizaCursor();
                break;
            }
            case 40: {
                if (this.selectionData.cursor < this.data.getBufferLength() - 16) {
                    this.selectionData.cursor += 16;
                }
                this.actualizaCursor();
                break;
            }
            case 16: {
                if (this.selectionData.isInSelection()) break;
                this.selectionData.startSelect(this.selectionData.cursor);
                this.repaint();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16 && this.selectionData.isInSelection()) {
            this.selectionData.endSelect(this.selectionData.cursor);
            this.repaint();
        }
    }

    public void goTo(int position) {
        if (position < 0) {
            position = 0;
        } else if (position >= this.data.getBufferLength()) {
            position = this.data.getBufferLength() - 1;
        }
        this.selectionData.cursor = position;
        this.actualizaCursor();
    }

    public void setClipboardContents(String data) {
        if (this.clipboard != null) {
            this.clipboard.setClipboardContents(data);
        }
    }

    public String getClipboardContents() {
        if (this.clipboard != null) {
            return this.clipboard.getClipboardContents();
        }
        return null;
    }

    public boolean hasClipboard() {
        return this.clipboard != null;
    }

    void saveData(String fileName, int start, int end) {
        block12: {
            FileOutputStream file = null;
            try {
                try {
                    file = new FileOutputStream(fileName);
                    this.data.saveToStream(file, start, end);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Could not write data to file \"" + fileName + "\"");
                    if (file == null) break block12;
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    void loadData(String fileName, int pos) {
        block12: {
            FileInputStream file = null;
            try {
                try {
                    file = new FileInputStream(fileName);
                    this.data.loadFromStream(file, pos);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Could not read data from file \"" + fileName + "\"");
                    if (file == null) break block12;
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class Caja
    extends JPanel {
        private Caja() {
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            FontMetrics fn = this.getFontMetrics(font);
            int h = fn.getHeight();
            d.setSize(fn.stringWidth(" ") + 1 + JHexEditor.this.border * 2 + 1, h + JHexEditor.this.border * 2 + 1);
            return d;
        }
    }

    private class Columnas
    extends JPanel {
        public Columnas() {
            this.setLayout(new BorderLayout(1, 1));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            FontMetrics fn = this.getFontMetrics(font);
            int h = fn.getHeight();
            int nl = 1;
            d.setSize((fn.stringWidth(" ") + 1) * 47 + JHexEditor.this.border * 2 + 1, h * nl + JHexEditor.this.border * 2 + 1);
            return d;
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getMinimumSize();
            g.setColor(Color.white);
            g.fillRect(0, 0, d.width, d.height);
            g.setColor(Color.black);
            g.setFont(font);
            int n = 0;
            while (n < 16) {
                if (n == JHexEditor.this.selectionData.cursor % 16) {
                    JHexEditor.this.cuadro(g, n * 3, 0, 2);
                }
                String s = "00" + Integer.toHexString(n);
                s = s.substring(s.length() - 2);
                JHexEditor.this.printString(g, s, n * 3, 0);
                ++n;
            }
        }
    }

    private class Filas
    extends JPanel {
        public Filas() {
            this.setLayout(new BorderLayout(1, 1));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            FontMetrics fn = this.getFontMetrics(font);
            int h = fn.getHeight();
            int nl = JHexEditor.this.getLineas();
            d.setSize((fn.stringWidth(" ") + 1) * 8 + JHexEditor.this.border * 2 + 1, h * nl + JHexEditor.this.border * 2 + 1);
            return d;
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getMinimumSize();
            g.setColor(Color.white);
            g.fillRect(0, 0, d.width, d.height);
            g.setColor(Color.black);
            g.setFont(font);
            int ini = JHexEditor.this.getInicio();
            int fin = ini + JHexEditor.this.getLineas();
            int y = 0;
            int n = ini;
            while (n < fin) {
                if (n == JHexEditor.this.selectionData.cursor / 16) {
                    JHexEditor.this.cuadro(g, 0, y, 8);
                }
                String s = "0000000000000" + Integer.toHexString(n * 16);
                s = s.substring(s.length() - 8);
                JHexEditor.this.printString(g, s, 0, y++);
                ++n;
            }
        }
    }
}

