/*
 * Decompiled with CFR 0.152.
 */
package com.jhe.hexed;

import com.jhe.hexed.JHexEditor;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class JHexEditorHEX
extends JComponent
implements MouseListener,
KeyListener,
MouseMotionListener {
    private JHexEditor he;
    private int cursor = 0;
    private JPopupMenu popup = new JPopupMenu();

    public JHexEditorHEX(JHexEditor he) {
        this.he = he;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(he);
        this.initPopUp();
    }

    private void initPopUp() {
        JMenuItem itemSelectAll = new JMenuItem("Select all");
        itemSelectAll.addActionListener(new SelectAllCommand());
        this.popup.add(itemSelectAll);
        this.popup.addSeparator();
        if (this.he.hasClipboard()) {
            JMenuItem itemCopy = new JMenuItem("Copy", new ImageIcon("images/copy_icon.png"));
            itemCopy.addActionListener(new CopyCommand());
            this.popup.add(itemCopy);
            JMenuItem itemPaste = new JMenuItem("Paste", new ImageIcon("images/paste_icon.png"));
            itemPaste.addActionListener(new PasteCommand());
            this.popup.add(itemPaste);
            this.popup.addSeparator();
        }
        JMenuItem itemClear = new JMenuItem("Set to 0");
        itemClear.addActionListener(new ClearCommand());
        this.popup.add(itemClear);
        JMenuItem itemFill = new JMenuItem("Fill...");
        itemFill.addActionListener(new FillCommand());
        this.popup.add(itemFill);
        this.popup.addSeparator();
        JMenuItem itemSave = new JMenuItem("Save...", new ImageIcon("images/file_save.png"));
        itemSave.addActionListener(new SaveCommand());
        this.popup.add(itemSave);
        JMenuItem itemLoad = new JMenuItem("Load...", new ImageIcon("images/file_load.png"));
        itemLoad.addActionListener(new LoadCommand());
        this.popup.add(itemLoad);
    }

    @Override
    public Dimension getPreferredSize() {
        this.debug("getPreferredSize()");
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        this.debug("getMaximumSize()");
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        this.debug("getMinimumSize()");
        Dimension d = new Dimension();
        FontMetrics fn = this.getFontMetrics(JHexEditor.font);
        int h = fn.getHeight();
        int nl = this.he.getLineas();
        d.setSize((fn.stringWidth(" ") + 1) * 47 + this.he.border * 2 + 1, h * nl + this.he.border * 2 + 1);
        return d;
    }

    @Override
    public void paint(Graphics g) {
        this.debug("paint(" + g + ")");
        this.debug("cursor=" + this.he.selectionData.cursor + " buffer length=" + this.he.data.getBufferLength());
        Dimension d = this.getMinimumSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(Color.black);
        g.setFont(JHexEditor.font);
        int ini = this.he.getInicio() * 16;
        int fin = ini + this.he.getLineas() * 16;
        if (fin > this.he.data.getBufferLength()) {
            fin = this.he.data.getBufferLength();
        }
        int x = 0;
        int y = 0;
        int n = ini;
        while (n < fin) {
            if (n >= this.he.selectionData.getSelectionFirst() && n <= this.he.selectionData.getSelectionLast()) {
                if (this.he.selectionData.isInSelection()) {
                    g.setColor(Color.yellow);
                    this.he.fondo(g, x * 3, y, 2);
                    g.setColor(Color.black);
                } else if (n == this.he.selectionData.cursor) {
                    this.drawCursor(g, x, y);
                } else {
                    g.setColor(Color.blue);
                    this.he.fondo(g, x * 3, y, 2);
                    g.setColor(Color.white);
                }
            } else if (n == this.he.selectionData.cursor) {
                this.drawCursor(g, x, y);
            } else {
                g.setColor(Color.black);
            }
            String s = "0" + Integer.toHexString(this.he.data.getBufferByte(n));
            s = s.substring(s.length() - 2);
            this.he.printString(g, s, x++ * 3, y);
            if (x == 16) {
                x = 0;
                ++y;
            }
            ++n;
        }
    }

    private void drawCursor(Graphics g, int x, int y) {
        if (this.isFocusOwner()) {
            g.setColor(Color.black);
            this.he.fondo(g, x * 3, y, 2);
            g.setColor(Color.blue);
            this.he.fondo(g, x * 3 + this.cursor, y, 1);
        } else {
            g.setColor(Color.blue);
            this.he.cuadro(g, x * 3, y, 2);
        }
        if (this.isFocusOwner()) {
            g.setColor(Color.white);
        } else {
            g.setColor(Color.black);
        }
    }

    private void debug(String s) {
        this.he.debugPrintLine("JHexEditorHEX ==> " + s);
    }

    public int calcularPosicionRaton(int x, int y) {
        FontMetrics fn = this.getFontMetrics(JHexEditor.font);
        this.debug("x=" + (x /= (fn.stringWidth(" ") + 1) * 3) + " ,y=" + (y /= fn.getHeight()));
        return x + (y + this.he.getInicio()) * 16;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.debug("mouseClicked(" + event + ")");
        if (!this.checkPopup(event)) {
            this.handleSelect(event.getPoint());
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.debug("mousePressed(" + event + ")");
        if (!this.checkPopup(event) && event.getButton() == 1) {
            this.beginDrag(event.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.debug("mouseReleased(" + event + ")");
        if (!this.checkPopup(event) && this.he.selectionData.isInSelection()) {
            this.endDrag(event.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.debug("mouseEntered(" + event + ")");
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.debug("mouseExited(" + event + ")");
        if (this.he.selectionData.isInSelection()) {
            this.cancelDrag();
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.debug("mouseDragged(" + event + ")");
        if (!this.checkPopup(event) && this.he.selectionData.isInSelection()) {
            if (this.isInside(event.getPoint())) {
                this.doDrag(event.getPoint());
            } else {
                this.cancelDrag();
            }
        }
    }

    private boolean isInside(Point relativePoint) {
        Point absolutePoint = new Point(relativePoint);
        absolutePoint.move((int)this.getBounds().getX(), (int)this.getBounds().getY());
        return this.getBounds().contains(absolutePoint);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.debug("mouseMoved(" + event + ")");
    }

    private boolean checkPopup(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.handleSelect(event.getPoint());
            this.popup.show(this, event.getX(), event.getY());
            return true;
        }
        return false;
    }

    private void handleSelect(Point point) {
        this.he.selectionData.cursor = this.calcularPosicionRaton((int)point.getX(), (int)point.getY());
        this.updateView();
    }

    private void updateView() {
        this.requestFocus();
        this.he.repaint();
    }

    private void beginDrag(Point point) {
        this.he.selectionData.startSelect(this.calcularPosicionRaton((int)point.getX(), (int)point.getY()));
        this.updateView();
    }

    private void doDrag(Point point) {
        this.he.selectionData.updateSelection(this.calcularPosicionRaton((int)point.getX(), (int)point.getY()));
        this.updateView();
    }

    private void endDrag(Point point) {
        this.he.selectionData.endSelect(this.calcularPosicionRaton((int)point.getX(), (int)point.getY()));
        this.updateView();
    }

    private void cancelDrag() {
        this.he.selectionData.clear();
        this.updateView();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.debug("keyTyped(" + e + ")");
        char c = e.getKeyChar();
        if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
            char[] str = new char[2];
            String n = "00" + Integer.toHexString(this.he.data.getBufferByte(this.he.selectionData.cursor));
            if (n.length() > 2) {
                n = n.substring(n.length() - 2);
            }
            str[1 - this.cursor] = n.charAt(1 - this.cursor);
            str[this.cursor] = e.getKeyChar();
            this.he.data.setBufferByte(this.he.selectionData.cursor, (byte)Integer.parseInt(new String(str), 16));
            if (this.cursor != 1) {
                this.cursor = 1;
            } else if (this.he.selectionData.cursor != this.he.data.getBufferLength() - 1) {
                ++this.he.selectionData.cursor;
                this.cursor = 0;
            }
            this.he.actualizaCursor();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.debug("keyPressed(" + e + ")");
        this.he.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.debug("keyReleased(" + e + ")");
        this.he.keyReleased(e);
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public Frame getFrame() {
        Container container = this.he.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public class ClearCommand
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.getSelectionStart();
            while (i <= ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.getSelectionEnd()) {
                ((JHexEditorHEX)JHexEditorHEX.this).he.data.setBufferByte(i, (byte)0);
                ++i;
            }
            JHexEditorHEX.this.updateView();
        }
    }

    public class CopyCommand
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String data = "";
            int i = ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.getSelectionStart();
            while (i <= ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.getSelectionEnd()) {
                data = String.valueOf(data) + (char)((JHexEditorHEX)JHexEditorHEX.this).he.data.getBufferByte(i);
                ++i;
            }
            JHexEditorHEX.this.he.setClipboardContents(data);
        }
    }

    public class FillCommand
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String fillPattern = JOptionPane.showInputDialog(JHexEditorHEX.this.he, (Object)"Enter fill pattern (sequence of hex numbers)");
            if (fillPattern != null && !fillPattern.isEmpty()) {
                String[] patternElements = fillPattern.split(" ");
                byte[] numbers = new byte[patternElements.length];
                int i = 0;
                try {
                    i = 0;
                    while (i < patternElements.length) {
                        numbers[i] = (byte)Integer.parseInt(new String(patternElements[i]), 16);
                        ++i;
                    }
                    i = 0;
                    int j = ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.getSelectionStart();
                    while (j <= ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.getSelectionEnd()) {
                        ((JHexEditorHEX)JHexEditorHEX.this).he.data.setBufferByte(j, numbers[i]);
                        i = (i + 1) % numbers.length;
                        ++j;
                    }
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(JHexEditorHEX.this.he, String.valueOf(patternElements[i]) + " is not a valid hex number");
                }
            }
        }
    }

    public class LoadCommand
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String selected_file;
            FileDialog fd = null;
            fd = new FileDialog(JHexEditorHEX.this.getFrame(), "Load data from file", 0);
            fd.setVisible(true);
            if (fd.getDirectory() != null && fd.getFile() != null && !(selected_file = String.valueOf(fd.getDirectory()) + fd.getFile()).isEmpty()) {
                JHexEditorHEX.this.he.loadData(selected_file, ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.cursor);
            }
        }
    }

    public class PasteCommand
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String data = JHexEditorHEX.this.he.getClipboardContents();
            if (data != null && !data.isEmpty()) {
                int end_pos = ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.cursor;
                int i = 0;
                while (i < data.length() && end_pos < ((JHexEditorHEX)JHexEditorHEX.this).he.data.getBufferLength()) {
                    ((JHexEditorHEX)JHexEditorHEX.this).he.data.setBufferByte(end_pos, (byte)data.charAt(i));
                    ++i;
                    ++end_pos;
                }
                if (--end_pos > ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.cursor) {
                    ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.selectRange(((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.cursor, end_pos);
                }
            } else {
                ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.clear();
            }
            JHexEditorHEX.this.updateView();
        }
    }

    public class SaveCommand
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String selected_file;
            FileDialog fd = null;
            fd = new FileDialog(JHexEditorHEX.this.getFrame(), "Save data to file", 1);
            fd.setVisible(true);
            if (fd.getDirectory() != null && fd.getFile() != null && !(selected_file = String.valueOf(fd.getDirectory()) + fd.getFile()).isEmpty()) {
                JHexEditorHEX.this.he.saveData(selected_file, ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.getSelectionStart(), ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.getSelectionEnd());
            }
        }
    }

    public class SelectAllCommand
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ((JHexEditorHEX)JHexEditorHEX.this).he.selectionData.selectRange(0, ((JHexEditorHEX)JHexEditorHEX.this).he.data.getBufferLength() - 1);
            JHexEditorHEX.this.updateView();
        }
    }
}

