/*
 * Decompiled with CFR 0.152.
 */
package com.jhe.hexed;

public class JHexEditorSelection {
    public int cursor;
    private int selectionStart;
    private int selectionEnd;
    private boolean isInSelection;

    public JHexEditorSelection() {
        this.clear();
    }

    public void clear() {
        this.selectionEnd = -1;
        this.selectionStart = -1;
        this.isInSelection = false;
    }

    public int getSelectionStart() {
        return this.selectionStart == this.selectionEnd ? this.cursor : this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionStart == this.selectionEnd ? this.cursor : this.selectionEnd;
    }

    public int getSelectionFirst() {
        return this.selectionStart < this.selectionEnd ? this.selectionStart : this.selectionEnd;
    }

    public int getSelectionLast() {
        return this.selectionStart > this.selectionEnd ? this.selectionStart : this.selectionEnd;
    }

    public void selectRange(int start, int end) {
        this.selectionStart = start;
        this.selectionEnd = end;
    }

    public boolean isInSelection() {
        return this.isInSelection;
    }

    public void startSelect(int pos_from) {
        this.selectRange(pos_from, pos_from);
        this.isInSelection = true;
    }

    public void updateSelection(int pos_to) {
        this.selectionEnd = pos_to;
    }

    public void endSelect(int pos_to) {
        this.cursor = this.selectionStart;
        this.selectionEnd = pos_to;
        if (this.selectionEnd == this.selectionStart) {
            this.selectionEnd = -1;
            this.selectionStart = -1;
        } else if (this.selectionStart > this.selectionEnd) {
            this.selectRange(this.selectionEnd, this.selectionStart);
        }
        this.isInSelection = false;
    }
}

