/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.io;

import emulator.util.AddressRange;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import layout.SpringUtilities;

public class IrqPanel
extends JPanel {
    private JTextField flagsEdit = new JTextField("%MMMMMMMM");
    private JTextField maskEdit = new JTextField("%MMMMMMMM");
    private JTextField activeEdit = new JTextField("%MMMMMMMM");

    public IrqPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new SpringLayout());
        this.setBorder(BorderFactory.createTitledBorder("IRQ"));
        this.add(new JLabel("Flags"));
        this.add(this.flagsEdit);
        this.add(new JLabel("Mask"));
        this.add(this.maskEdit);
        this.add(new JLabel("Active"));
        this.add(this.activeEdit);
        this.activeEdit.setEditable(false);
        SpringUtilities.makeGrid(this, 3, 2, 5, 5, 5, 5);
    }

    public void setFlagsValue(int flagsValue) {
        this.flagsEdit.setText("%" + AddressRange.toBinaryString(flagsValue, 8));
        this.updateActiveStatus();
    }

    public int getFlagsValue() {
        return AddressRange.addressFromString(this.flagsEdit.getText());
    }

    public void setMaskValue(int maskValue) {
        this.maskEdit.setText("%" + AddressRange.toBinaryString(maskValue, 8));
        this.updateActiveStatus();
    }

    public int getMaskValue() {
        return AddressRange.addressFromString(this.maskEdit.getText());
    }

    private void updateActiveStatus() {
        try {
            int active = this.getFlagsValue() & this.getMaskValue();
            this.activeEdit.setText("%" + AddressRange.toBinaryString(active, 8));
            this.activeEdit.setForeground(active > 0 ? Color.BLACK : Color.GRAY);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

