/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.io;

import emulator.hardware.io.Port6522;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PortPanel
extends JPanel {
    private static ImageIcon disabledOff = new ImageIcon("images/red-off-16.png");
    private static ImageIcon disabledOn = new ImageIcon("images/green-off-16.png");
    private static ImageIcon enabledOff = new ImageIcon("images/red-on-16.png");
    private static ImageIcon enabledOn = new ImageIcon("images/green-on-16.png");
    private static ImageIcon fallingEdgeIn = new ImageIcon("images/falling-edge-in.png");
    private static ImageIcon fallingEdgeInR = new ImageIcon("images/falling-edge-in-r.png");
    private static ImageIcon risingEdgeIn = new ImageIcon("images/rising-edge-in.png");
    private static ImageIcon risingEdgeInR = new ImageIcon("images/rising-edge-in-r.png");
    private static ImageIcon handshakeOut = new ImageIcon("images/handshake-out.png");
    private static ImageIcon pulseOut = new ImageIcon("images/pulse-out.png");
    private static ImageIcon lowOut = new ImageIcon("images/low-out.png");
    private static ImageIcon highOut = new ImageIcon("images/high-out.png");
    private static String[] modeTips1 = new String[]{"Negative active edge", "Positive active edge"};
    private static String[] modeTips2 = new String[]{"Input negative active edge", "Independent interrupt input negative edge", "Input positive active edge", "Independent interrupt input positive edge", "Handshake output", "Pulse output", "Low output", "High output"};
    ImageIcon[] modeIcons1 = new ImageIcon[]{fallingEdgeIn, risingEdgeIn};
    ImageIcon[] modeIcons2 = new ImageIcon[]{fallingEdgeInR, fallingEdgeIn, risingEdgeInR, risingEdgeIn, handshakeOut, pulseOut, lowOut, highOut};
    JLabel[] portLabel = new JLabel[8];
    JLabel[] portIn = new JLabel[8];
    JLabel[] portOut = new JLabel[8];
    JLabel c1state = new JLabel(enabledOff);
    JLabel c1mode = new JLabel(fallingEdgeIn);
    JLabel c2state = new JLabel(enabledOff);
    JLabel c2mode = new JLabel(fallingEdgeInR);

    public PortPanel(String portName) {
        this.initPanel(portName);
    }

    private void initPanel(String portName) {
        this.setBorder(BorderFactory.createTitledBorder("Port " + portName));
        JLabel labelIn = new JLabel("In");
        JLabel labelOut = new JLabel("Out");
        int i = 0;
        while (i < 8) {
            this.portLabel[i] = new JLabel("P" + portName + i);
            this.add(this.portLabel[i]);
            this.portIn[i] = new JLabel(disabledOff);
            this.add(this.portIn[i]);
            this.portOut[i] = new JLabel(disabledOff);
            this.add(this.portOut[i]);
            ++i;
        }
        JLabel c1Label = new JLabel("C" + portName + "1");
        JLabel c2Label = new JLabel("C" + portName + "2");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup horGroup = layout.createSequentialGroup();
        GroupLayout.SequentialGroup verGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup col0 = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
        GroupLayout.ParallelGroup col1 = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
        GroupLayout.ParallelGroup col2 = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
        col1.addComponent(labelIn);
        col2.addComponent(labelOut);
        verGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(labelIn).addComponent(labelOut));
        int i2 = 0;
        while (i2 < 8) {
            verGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.portLabel[i2]).addComponent(this.portIn[i2]).addComponent(this.portOut[i2]));
            col0.addComponent(this.portLabel[i2]);
            col1.addComponent(this.portIn[i2]);
            col2.addComponent(this.portOut[i2]);
            ++i2;
        }
        col0.addGap(5);
        col1.addGap(5);
        col2.addGap(5);
        verGroup.addGap(5);
        col0.addComponent(c1Label);
        col1.addComponent(this.c1state);
        col2.addComponent(this.c1mode);
        verGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(c1Label).addComponent(this.c1state).addComponent(this.c1mode));
        col0.addComponent(c2Label);
        col1.addComponent(this.c2state);
        col2.addComponent(this.c2mode);
        verGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(c2Label).addComponent(this.c2state).addComponent(this.c2mode));
        horGroup.addGroup(col0).addGroup(col1).addGroup(col2);
        layout.setHorizontalGroup(horGroup);
        layout.setVerticalGroup(verGroup);
    }

    public void setPortStatus(Port6522 port) {
        int mask = port.getPortMask();
        int i = 0;
        while (i < 8) {
            boolean isOut;
            boolean bl = isOut = (mask & 1 << i) != 0;
            if (port.getInPortBit(i).getValue()) {
                this.portIn[i].setIcon(isOut ? disabledOn : enabledOn);
            } else {
                this.portIn[i].setIcon(isOut ? disabledOff : enabledOff);
            }
            if (port.getOutPortBit(i).getValue()) {
                this.portOut[i].setIcon(isOut ? enabledOn : disabledOn);
            } else {
                this.portOut[i].setIcon(isOut ? enabledOff : disabledOff);
            }
            ++i;
        }
        this.c1state.setIcon(port.getControlBit(0).getValue() ? enabledOn : enabledOff);
        this.c2state.setIcon(port.getControlBit(1).getValue() ? enabledOn : enabledOff);
    }

    public void setPortControlModes(int mode1, int mode2) {
        this.c1mode.setIcon(this.modeIcons1[mode1]);
        this.c1mode.setToolTipText(modeTips1[mode1]);
        this.c2mode.setIcon(this.modeIcons2[mode2]);
        this.c2mode.setToolTipText(modeTips2[mode2]);
    }
}

